/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.util.logging.Logger;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;
import org.glassfish.jersey.ext.cdi1x.internal.spi.BeanManagerProvider;

final class DefaultBeanManagerProvider
implements BeanManagerProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultBeanManagerProvider.class.getName());

    DefaultBeanManagerProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanManager getBeanManager() {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            BeanManager beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            return beanManager;
        }
        catch (Exception ex) {
            try {
                BeanManager ignored = CDI.current().getBeanManager();
                return ignored;
            }
            catch (Exception e) {
                LOGGER.config(LocalizationMessages.CDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED());
                BeanManager beanManager = null;
                return beanManager;
            }
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException ignored) {}
            }
        }
    }
}

