/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.util.LinkedList;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2InjectedTarget;
import org.glassfish.jersey.ext.cdi1x.internal.spi.Hk2LocatorManager;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionTargetListener;

public abstract class GenericHk2LocatorManager
implements Hk2LocatorManager,
InjectionTargetListener {
    private final List<Hk2InjectedTarget> injectionTargets = new LinkedList<Hk2InjectedTarget>();
    private volatile ServiceLocator locator;
    private volatile boolean multipleLocators = false;

    @Override
    public void registerLocator(ServiceLocator locator) {
        if (!this.multipleLocators) {
            if (this.locator == null) {
                this.locator = locator;
            } else {
                this.locator = null;
                this.multipleLocators = true;
            }
            for (Hk2InjectedTarget target : this.injectionTargets) {
                target.setLocator(this.locator);
            }
        }
    }

    @Override
    public ServiceLocator getEffectiveLocator() {
        return !this.multipleLocators ? this.locator : this.lookupLocator();
    }

    public abstract ServiceLocator lookupLocator();

    @Override
    public void notify(Hk2InjectedTarget target) {
        this.injectionTargets.add(target);
    }
}

