/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.Application;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.jersey.ext.cdi1x.internal.AbstractCdiBeanSupplier;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProviderClientRuntimeSpecifics;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProviderRuntimeSpecifics;
import org.glassfish.jersey.ext.cdi1x.internal.CdiComponentProviderServerRuntimeSpecifics;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.GenericCdiBeanSupplier;
import org.glassfish.jersey.ext.cdi1x.internal.InjecteeSkippingAnalyzer;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.ext.cdi1x.internal.LocalizationMessages;
import org.glassfish.jersey.ext.cdi1x.internal.ProcessJAXRSAnnotatedTypes;
import org.glassfish.jersey.ext.cdi1x.internal.RequestScopedCdiBeanSupplier;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionManagerInjectedTarget;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionManagerStore;
import org.glassfish.jersey.ext.cdi1x.internal.spi.InjectionTargetListener;
import org.glassfish.jersey.ext.cdi1x.spi.Hk2CustomBoundTypesProvider;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.CustomAnnotationLiteral;
import org.glassfish.jersey.internal.inject.ForeignRequestScopeBridge;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.Cache;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.spi.ComponentProvider;

public class CdiComponentProvider
implements ComponentProvider,
Extension {
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    public static final String CDI_CLASS_ANALYZER = "CdiInjecteeSkippingClassAnalyzer";
    private static final CdiComponentProviderRuntimeSpecifics runtimeSpecifics = CdiUtil.IS_SERVER_AVAILABLE ? new CdiComponentProviderServerRuntimeSpecifics() : new CdiComponentProviderClientRuntimeSpecifics();
    private final Set<Type> jaxrsInjectableTypes = new HashSet<Type>();
    private final Set<Type> hk2ProvidedTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Type> jerseyVetoedTypes = Collections.synchronizedSet(new HashSet());
    private final Set<DependencyPredicate> jerseyOrDependencyTypes = Collections.synchronizedSet(new LinkedHashSet());
    private final ThreadLocal<InjectionManager> threadInjectionManagers = new ThreadLocal();
    private final Set<Class<?>> requestScopedComponents = new HashSet();
    private final Cache<Class<?>, Boolean> jaxRsComponentCache = new Cache(new Function<Class<?>, Boolean>(){

        @Override
        public Boolean apply(Class<?> clazz) {
            return Application.class.isAssignableFrom(clazz) || Providers.isJaxRsProvider(clazz) || runtimeSpecifics.isJaxRsResource(clazz);
        }
    });
    private final Hk2CustomBoundTypesProvider customHk2TypesProvider;
    private final InjectionManagerStore injectionManagerStore;
    private volatile InjectionManager injectionManager;
    protected volatile BeanManager beanManager;
    private volatile Map<Class<?>, Set<Method>> methodsToSkip = new HashMap();
    private volatile Map<Class<?>, Set<Field>> fieldsToSkip = new HashMap();

    public CdiComponentProvider() {
        this.customHk2TypesProvider = CdiUtil.lookupService(Hk2CustomBoundTypesProvider.class);
        this.injectionManagerStore = CdiUtil.createHk2InjectionManagerStore();
        this.addHK2DepenendencyCheck(CdiComponentProvider::isJerseyOrDependencyType);
    }

    public void initialize(InjectionManager injectionManager) {
        CdiComponentProvider extension;
        this.injectionManager = injectionManager;
        this.beanManager = CdiUtil.getBeanManager();
        if (this.beanManager != null && (extension = (CdiComponentProvider)this.beanManager.getExtension(CdiComponentProvider.class)) != null) {
            extension.addInjectionManager(this.injectionManager);
            this.fieldsToSkip = extension.getFieldsToSkip();
            this.methodsToSkip = extension.getMethodsToSkip();
            this.bindHk2ClassAnalyzer();
            LOGGER.config(LocalizationMessages.CDI_PROVIDER_INITIALIZED());
        }
    }

    public boolean bind(Class<?> clazz, Set<Class<?>> providerContracts) {
        return this.bind(clazz, providerContracts, -1);
    }

    public boolean bind(Class<?> component, ContractProvider contractProvider) {
        return contractProvider != null ? this.bind(component, contractProvider.getContracts(), contractProvider.getPriority(component)) : this.bind(component, Collections.EMPTY_SET);
    }

    private boolean bind(Class<?> clazz, Set<Class<?>> providerContracts, Integer priority) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CDI_CLASS_BEING_CHECKED(clazz));
        }
        if (this.beanManager == null) {
            return false;
        }
        if (clazz.isAnnotationPresent(Vetoed.class)) {
            return false;
        }
        if (CdiComponentProvider.isJerseyOrDependencyType(clazz)) {
            return false;
        }
        boolean isCdiManaged = this.isCdiComponent(clazz);
        boolean isManagedBean = this.isManagedBean(clazz);
        boolean isJaxRsComponent = this.isJaxRsComponentType(clazz);
        if (!(isCdiManaged || isManagedBean || isJaxRsComponent)) {
            return false;
        }
        boolean isJaxRsResource = runtimeSpecifics.isJaxRsResource(clazz);
        if (isJaxRsResource && !runtimeSpecifics.isAcceptableResource(clazz)) {
            LOGGER.log(clazz.isInterface() ? Level.FINE : Level.WARNING, LocalizationMessages.CDI_NON_INSTANTIABLE_COMPONENT(clazz));
            return false;
        }
        Class<? extends Annotation> beanScopeAnnotation = CdiUtil.getBeanScope(clazz, this.beanManager);
        boolean isRequestScoped = beanScopeAnnotation == RequestScoped.class || beanScopeAnnotation == Dependent.class && isJaxRsResource;
        AbstractCdiBeanSupplier beanFactory = isRequestScoped ? new RequestScopedCdiBeanSupplier((Class)clazz, this.injectionManager, this.beanManager, isCdiManaged) : new GenericCdiBeanSupplier((Class)clazz, this.injectionManager, this.beanManager, isCdiManaged);
        SupplierInstanceBinding builder = (SupplierInstanceBinding)((SupplierInstanceBinding)Bindings.supplier((Supplier)((Object)beanFactory)).to(clazz)).qualifiedBy((Annotation)CustomAnnotationLiteral.INSTANCE);
        for (Class<?> contract : providerContracts) {
            builder.to(contract);
        }
        if (priority > -1) {
            builder.ranked(priority.intValue());
        }
        if (clazz.isAnnotationPresent(Singleton.class) && beanScopeAnnotation == null) {
            builder.in(Singleton.class);
        }
        this.injectionManager.register((Binding)builder);
        if (isRequestScoped) {
            this.requestScopedComponents.add(clazz);
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.CDI_CLASS_BOUND_WITH_CDI(clazz));
        }
        return true;
    }

    public void done() {
        if (this.requestScopedComponents.size() > 0) {
            InstanceBinding descriptor = (InstanceBinding)Bindings.service(() -> this.requestScopedComponents).to(ForeignRequestScopeBridge.class);
            this.injectionManager.register((Binding)descriptor);
            if (LOGGER.isLoggable(Level.CONFIG)) {
                LOGGER.config(LocalizationMessages.CDI_REQUEST_SCOPED_COMPONENTS_RECOGNIZED(this.listElements(new StringBuilder().append("\n"), this.requestScopedComponents).toString()));
            }
        }
    }

    private boolean isCdiComponent(Class<?> component) {
        Annotation[] qualifiers = CdiUtil.getQualifiers(component.getAnnotations());
        return !this.beanManager.getBeans(component, qualifiers).isEmpty();
    }

    private boolean isManagedBean(Class<?> component) {
        return component.isAnnotationPresent(ManagedBean.class);
    }

    private AnnotatedConstructor<?> enrichedConstructor(final AnnotatedConstructor<?> ctor) {
        return new AnnotatedConstructor(){

            public Constructor getJavaMember() {
                return ctor.getJavaMember();
            }

            public List<AnnotatedParameter> getParameters() {
                ArrayList<AnnotatedParameter> parameters = new ArrayList<AnnotatedParameter>(ctor.getParameters().size());
                for (AnnotatedParameter ap : ctor.getParameters()) {
                    parameters.add(runtimeSpecifics.getAnnotatedParameter(ap));
                }
                return parameters;
            }

            public boolean isStatic() {
                return ctor.isStatic();
            }

            public AnnotatedType getDeclaringType() {
                return ctor.getDeclaringType();
            }

            public Type getBaseType() {
                return ctor.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return ctor.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return (T)ctor.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return ctor.getAnnotations();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return ctor.isAnnotationPresent(annotationType);
            }
        };
    }

    private static boolean containsJaxRsConstructorInjection(AnnotatedType annotatedType) {
        return CdiComponentProvider.containAnnotatedParameters(annotatedType.getConstructors(), runtimeSpecifics.getJaxRsInjectAnnotations());
    }

    private static boolean containsJaxRsMethodInjection(AnnotatedType annotatedType) {
        return CdiComponentProvider.containAnnotatedParameters(annotatedType.getMethods(), runtimeSpecifics.getJaxRsInjectAnnotations());
    }

    private static boolean containsJaxRsFieldInjection(AnnotatedType annotatedType) {
        return CdiComponentProvider.containAnnotation(annotatedType.getFields(), runtimeSpecifics.getJaxRsInjectAnnotations());
    }

    static boolean containAnnotatedParameters(Collection<AnnotatedCallable> annotatedCallables, Set<Class<? extends Annotation>> annotationSet) {
        for (AnnotatedCallable c : annotatedCallables) {
            if (!CdiComponentProvider.containAnnotation(c.getParameters(), annotationSet)) continue;
            return true;
        }
        return false;
    }

    private static boolean containAnnotation(Collection<Annotated> elements, Set<Class<? extends Annotation>> annotationSet) {
        for (Annotated element : elements) {
            if (!CdiComponentProvider.hasAnnotation(element, annotationSet)) continue;
            return true;
        }
        return false;
    }

    static boolean hasAnnotation(Annotated element, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> a : annotations) {
            if (!element.isAnnotationPresent(a)) continue;
            return true;
        }
        return false;
    }

    public void processAnnotatedType(ProcessAnnotatedType processAnnotatedType) {
        final AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        if (CdiComponentProvider.containsJaxRsConstructorInjection(annotatedType) || CdiComponentProvider.containsJaxRsFieldInjection(annotatedType) || CdiComponentProvider.containsJaxRsMethodInjection(annotatedType)) {
            this.jaxrsInjectableTypes.add(annotatedType.getBaseType());
        }
        if (this.customHk2TypesProvider != null) {
            Type baseType = annotatedType.getBaseType();
            if (this.customHk2TypesProvider.getHk2Types().contains(baseType)) {
                processAnnotatedType.veto();
                this.jerseyVetoedTypes.add(baseType);
            }
        }
        if (runtimeSpecifics.containsJaxRsParameterizedCtor(annotatedType)) {
            processAnnotatedType.setAnnotatedType(new AnnotatedType(){

                public Class getJavaClass() {
                    return annotatedType.getJavaClass();
                }

                public Set<AnnotatedConstructor> getConstructors() {
                    HashSet<AnnotatedConstructor> result = new HashSet<AnnotatedConstructor>();
                    for (AnnotatedConstructor c : annotatedType.getConstructors()) {
                        result.add(CdiComponentProvider.this.enrichedConstructor(c));
                    }
                    return result;
                }

                public Set getMethods() {
                    return annotatedType.getMethods();
                }

                public Set getFields() {
                    return annotatedType.getFields();
                }

                public Type getBaseType() {
                    return annotatedType.getBaseType();
                }

                public Set<Type> getTypeClosure() {
                    return annotatedType.getTypeClosure();
                }

                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    return (T)annotatedType.getAnnotation(annotationType);
                }

                public Set<Annotation> getAnnotations() {
                    return annotatedType.getAnnotations();
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                    return annotatedType.isAnnotationPresent(annotationType);
                }
            });
        }
    }

    private Set<InjectionPoint> filterHk2InjectionPointsOut(Set<InjectionPoint> originalInjectionPoints) {
        HashSet<InjectionPoint> filteredInjectionPoints = new HashSet<InjectionPoint>();
        for (InjectionPoint ip : originalInjectionPoints) {
            Type injectedType = ip.getType();
            if (this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(injectedType)) {
                this.hk2ProvidedTypes.add(injectedType);
                continue;
            }
            if (injectedType instanceof Class) {
                Class injectedClass = (Class)injectedType;
                if (this.testDependencyType(injectedClass)) {
                    this.hk2ProvidedTypes.add(injectedType);
                    continue;
                }
                filteredInjectionPoints.add(ip);
                continue;
            }
            if (this.isInjectionProvider(injectedType) && this.isProviderOfJerseyType((ParameterizedType)injectedType)) {
                this.hk2ProvidedTypes.add(((ParameterizedType)injectedType).getActualTypeArguments()[0]);
                continue;
            }
            filteredInjectionPoints.add(ip);
        }
        return filteredInjectionPoints;
    }

    private boolean isInjectionProvider(Type injectedType) {
        return injectedType instanceof ParameterizedType && ((ParameterizedType)injectedType).getRawType() == Provider.class;
    }

    private boolean isProviderOfJerseyType(ParameterizedType provider) {
        Type firstArgumentType = provider.getActualTypeArguments()[0];
        if (firstArgumentType instanceof Class && CdiComponentProvider.isJerseyOrDependencyType((Class)firstArgumentType)) {
            return true;
        }
        return this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(firstArgumentType);
    }

    private <T> void addInjecteeToSkip(Class<?> componentClass, Map<Class<?>, Set<T>> toSkip, T member) {
        if (!toSkip.containsKey(componentClass)) {
            toSkip.put(componentClass, new HashSet());
        }
        toSkip.get(componentClass).add(member);
    }

    boolean isHk2ProvidedType(Type type) {
        return this.hk2ProvidedTypes.contains(type);
    }

    Map<Class<?>, Set<Field>> getFieldsToSkip() {
        return this.fieldsToSkip;
    }

    Map<Class<?>, Set<Method>> getMethodsToSkip() {
        return this.methodsToSkip;
    }

    InjectionManager getEffectiveInjectionManager() {
        return this.injectionManagerStore.getEffectiveInjectionManager();
    }

    void addInjectionManager(InjectionManager injectionManager) {
        this.injectionManagerStore.registerInjectionManager(injectionManager);
    }

    void notify(InjectionManagerInjectedTarget target) {
        if (this.injectionManagerStore instanceof InjectionTargetListener) {
            ((InjectionTargetListener)((Object)this.injectionManagerStore)).notify(target);
        }
    }

    boolean isJaxRsComponentType(Class<?> clazz) {
        return (Boolean)this.jaxRsComponentCache.apply(clazz);
    }

    private static boolean isJerseyOrDependencyType(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isSynthetic()) {
            return false;
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            LOGGER.warning(String.format("Class %s has null package", clazz));
            return false;
        }
        String pkgName = pkg.getName();
        return !clazz.isAnnotationPresent(JerseyVetoed.class) && (pkgName.contains("org.glassfish.hk2") || pkgName.contains("jersey.repackaged") || pkgName.contains("org.jvnet.hk2") || pkgName.startsWith("org.glassfish.jersey") && !pkgName.startsWith("org.glassfish.jersey.examples") && !pkgName.startsWith("org.glassfish.jersey.tests") || pkgName.startsWith("com.sun.jersey") && !pkgName.startsWith("com.sun.jersey.examples") && !pkgName.startsWith("com.sun.jersey.tests"));
    }

    private boolean testDependencyType(Class<?> clazz) {
        for (Predicate predicate : this.jerseyOrDependencyTypes) {
            if (!predicate.test(clazz)) continue;
            return true;
        }
        return false;
    }

    private void bindHk2ClassAnalyzer() {
        ClassAnalyzer defaultClassAnalyzer = (ClassAnalyzer)this.injectionManager.getInstance(ClassAnalyzer.class, "default");
        int skippedElements = this.methodsToSkip.size() + this.fieldsToSkip.size();
        final ClassAnalyzer customizedClassAnalyzer = skippedElements > 0 ? new InjecteeSkippingAnalyzer(defaultClassAnalyzer, this.methodsToSkip, this.fieldsToSkip, this.beanManager) : defaultClassAnalyzer;
        AbstractBinder binder = new AbstractBinder(){

            protected void configure() {
                ((InstanceBinding)((InstanceBinding)this.bind(customizedClassAnalyzer).analyzeWith("default")).to(ClassAnalyzer.class)).named(CdiComponentProvider.CDI_CLASS_ANALYZER);
            }
        };
        this.injectionManager.register((Binder)binder);
    }

    private StringBuilder listElements(StringBuilder logMsgBuilder, Collection<? extends Object> elements) {
        for (Object object : elements) {
            logMsgBuilder.append(String.format(" - %s%n", object));
        }
        return logMsgBuilder;
    }

    private void processInjectionTarget(@Observes ProcessInjectionTarget event) {
        InjectionTarget it = event.getInjectionTarget();
        Class componentClass = event.getAnnotatedType().getJavaClass();
        final Set<InjectionPoint> cdiInjectionPoints = this.filterHk2InjectionPointsOut(it.getInjectionPoints());
        for (InjectionPoint injectionPoint : cdiInjectionPoints) {
            Member member = injectionPoint.getMember();
            if (member instanceof Field) {
                this.addInjecteeToSkip(componentClass, this.fieldsToSkip, (Field)member);
                continue;
            }
            if (!(member instanceof Method)) continue;
            this.addInjecteeToSkip(componentClass, this.methodsToSkip, (Method)member);
        }
        InjectionManagerInjectedCdiTarget target = null;
        if (CdiComponentProvider.isJerseyOrDependencyType(componentClass)) {
            target = new InjectionManagerInjectedCdiTarget(it){

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return Collections.emptySet();
                }
            };
        } else if (this.isJaxRsComponentType(componentClass) || this.jaxrsInjectableTypes.contains(event.getAnnotatedType().getBaseType())) {
            target = new InjectionManagerInjectedCdiTarget(it){

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return cdiInjectionPoints;
                }
            };
        }
        if (target != null) {
            this.notify(target);
            event.setInjectionTarget((InjectionTarget)target);
        }
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        if (LOGGER.isLoggable(Level.CONFIG) && !this.jerseyVetoedTypes.isEmpty()) {
            LOGGER.config(LocalizationMessages.CDI_TYPE_VETOED(this.customHk2TypesProvider, this.listElements(new StringBuilder().append("\n"), this.jerseyVetoedTypes).toString()));
        }
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery abd) {
        if (this.customHk2TypesProvider != null) {
            this.hk2ProvidedTypes.addAll(this.customHk2TypesProvider.getHk2Types());
        }
        for (Type t : this.hk2ProvidedTypes) {
            abd.addBean((Bean)new Hk2Bean(t));
        }
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        if (CdiUtil.IS_SERVER_AVAILABLE) {
            beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(CdiComponentProviderServerRuntimeSpecifics.JaxRsParamProducer.class), "Jersey " + CdiComponentProviderServerRuntimeSpecifics.JaxRsParamProducer.class.getName());
        }
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(ProcessJAXRSAnnotatedTypes.class), "Jersey " + ProcessJAXRSAnnotatedTypes.class.getName());
    }

    private void beforeShutDown(@Observes BeforeShutdown beforeShutdown, BeanManager beanManager) {
        runtimeSpecifics.clearJaxRsResource(Thread.currentThread().getContextClassLoader());
    }

    public void addHK2DepenendencyCheck(Predicate<Class<?>> predicate) {
        this.jerseyOrDependencyTypes.add(new DependencyPredicate(predicate));
    }

    private final class DependencyPredicate
    implements Predicate<Class<?>> {
        private final Predicate<Class<?>> predicate;

        public DependencyPredicate(Predicate<Class<?>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(Class<?> aClass) {
            return this.predicate.test(aClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyPredicate that = (DependencyPredicate)o;
            return this.predicate.getClass().equals(that.predicate);
        }

        public int hashCode() {
            return this.predicate.getClass().hashCode();
        }
    }

    private class Hk2Bean
    implements Bean {
        private final Type t;

        public Hk2Bean(Type t) {
            this.t = t;
        }

        public Class getBeanClass() {
            return (Class)this.t;
        }

        public Set getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return true;
        }

        public Object create(CreationalContext creationalContext) {
            InjectionManager injectionManager = CdiComponentProvider.this.getEffectiveInjectionManager();
            if (injectionManager == null) {
                injectionManager = (InjectionManager)CdiComponentProvider.this.threadInjectionManagers.get();
            }
            return injectionManager.getInstance(this.t);
        }

        public void destroy(Object instance, CreationalContext creationalContext) {
        }

        public Set getTypes() {
            return Collections.singleton(this.t);
        }

        public Set getQualifiers() {
            return Collections.singleton(new CdiDefaultAnnotation());
        }

        public Class getScope() {
            return Dependent.class;
        }

        public String getName() {
            return this.t.toString();
        }

        public Set getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }
    }

    abstract class InjectionManagerInjectedCdiTarget
    implements InjectionManagerInjectedTarget {
        private final InjectionTarget delegate;
        private volatile InjectionManager effectiveInjectionManager;

        public InjectionManagerInjectedCdiTarget(InjectionTarget delegate) {
            this.delegate = delegate;
        }

        public abstract Set<InjectionPoint> getInjectionPoints();

        public void inject(Object t, CreationalContext cc) {
            InjectionManager injectingManager = CdiComponentProvider.this.getEffectiveInjectionManager();
            if (injectingManager == null) {
                injectingManager = this.effectiveInjectionManager;
                CdiComponentProvider.this.threadInjectionManagers.set(injectingManager);
            }
            this.delegate.inject(t, cc);
            if (injectingManager != null) {
                injectingManager.inject(t, CdiComponentProvider.CDI_CLASS_ANALYZER);
            }
            CdiComponentProvider.this.threadInjectionManagers.remove();
        }

        public void postConstruct(Object t) {
            this.delegate.postConstruct(t);
        }

        public void preDestroy(Object t) {
            this.delegate.preDestroy(t);
        }

        public Object produce(CreationalContext cc) {
            return this.delegate.produce(cc);
        }

        public void dispose(Object t) {
            this.delegate.dispose(t);
        }

        @Override
        public void setInjectionManager(InjectionManager injectionManager) {
            this.effectiveInjectionManager = injectionManager;
        }
    }

    public static class CdiDefaultAnnotation
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;
    }
}

