
package org.glassfish.jersey.ext.cdi1x.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.ext.cdi1x.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableCDI_TYPE_VETOED(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("cdi.type.vetoed", arg0, arg1);
    }

    /**
     * The following types have been vetoed by Jersey as per {0} configuration: {1}
     * 
     */
    public static String CDI_TYPE_VETOED(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableCDI_TYPE_VETOED(arg0, arg1));
    }

    public static Localizable localizableCDI_CLASS_BOUND_WITH_CDI(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.class.bound.with.cdi", arg0);
    }

    /**
     * Class, {0}, has been bound by Jersey CDI component provider.
     * 
     */
    public static String CDI_CLASS_BOUND_WITH_CDI(Object arg0) {
        return LOCALIZER.localize(localizableCDI_CLASS_BOUND_WITH_CDI(arg0));
    }

    public static Localizable localizableCDI_LOOKUP_FAILED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.lookup.failed", arg0);
    }

    /**
     * Error when lookup instance of class, {0}, in CDI.
     * 
     */
    public static String CDI_LOOKUP_FAILED(Object arg0) {
        return LOCALIZER.localize(localizableCDI_LOOKUP_FAILED(arg0));
    }

    public static Localizable localizableCDI_CLASS_BEING_CHECKED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.class.being.checked", arg0);
    }

    /**
     * Class, {0}, is being checked with Jersey CDI component provider.
     * 
     */
    public static String CDI_CLASS_BEING_CHECKED(Object arg0) {
        return LOCALIZER.localize(localizableCDI_CLASS_BEING_CHECKED(arg0));
    }

    public static Localizable localizableCDI_NON_INSTANTIABLE_COMPONENT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.non.instantiable.component", arg0);
    }

    /**
     * Component of class {0} cannot be instantiated and will be ignored.
     * 
     */
    public static String CDI_NON_INSTANTIABLE_COMPONENT(Object arg0) {
        return LOCALIZER.localize(localizableCDI_NON_INSTANTIABLE_COMPONENT(arg0));
    }

    public static Localizable localizableCDI_PROVIDER_INITIALIZED() {
        return MESSAGE_FACTORY.getMessage("cdi.provider.initialized");
    }

    /**
     * Jersey CDI component provider initialized.
     * 
     */
    public static String CDI_PROVIDER_INITIALIZED() {
        return LOCALIZER.localize(localizableCDI_PROVIDER_INITIALIZED());
    }

    public static Localizable localizableCDI_MULTIPLE_LOCATORS_INTO_SIMPLE_APP() {
        return MESSAGE_FACTORY.getMessage("cdi.multiple.locators.into.simple.app");
    }

    /**
     * Trying to register multiple service locators into single service locator application.
     * 
     */
    public static String CDI_MULTIPLE_LOCATORS_INTO_SIMPLE_APP() {
        return LOCALIZER.localize(localizableCDI_MULTIPLE_LOCATORS_INTO_SIMPLE_APP());
    }

    public static Localizable localizableCDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED() {
        return MESSAGE_FACTORY.getMessage("cdi.bean.manager.jndi.lookup.failed");
    }

    /**
     * Failed to obtain BeanManager from JNDI lookup.
     * 
     */
    public static String CDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED() {
        return LOCALIZER.localize(localizableCDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED());
    }

    public static Localizable localizableCDI_CLASS_ANALYZER_MISUSED() {
        return MESSAGE_FACTORY.getMessage("cdi.class.analyzer.misused");
    }

    /**
     * Jersey CDI class analyzer is supposed to be used only for field and method inspection when injecting CDI beans.
     * 
     */
    public static String CDI_CLASS_ANALYZER_MISUSED() {
        return LOCALIZER.localize(localizableCDI_CLASS_ANALYZER_MISUSED());
    }

    public static Localizable localizableCDI_REQUEST_SCOPED_COMPONENTS_RECOGNIZED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.request.scoped.components.recognized", arg0);
    }

    /**
     * The following CDI types were recognized as request scoped components in Jersey: {0}.
     * 
     */
    public static String CDI_REQUEST_SCOPED_COMPONENTS_RECOGNIZED(Object arg0) {
        return LOCALIZER.localize(localizableCDI_REQUEST_SCOPED_COMPONENTS_RECOGNIZED(arg0));
    }

    public static Localizable localizableCDI_HK_2_BEAN_REGISTERED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("cdi.hk2.bean.registered", arg0);
    }

    /**
     * CDI beans backed by HK2 have been registered for the following types: {0}
     * 
     */
    public static String CDI_HK_2_BEAN_REGISTERED(Object arg0) {
        return LOCALIZER.localize(localizableCDI_HK_2_BEAN_REGISTERED(arg0));
    }

    public static Localizable localizableCDI_FAILED_LOADING(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("cdi.failed.loading", arg0, arg1);
    }

    /**
     * CDI failed instantiating the class {0} with {1}, falling back to HK2.
     * 
     */
    public static String CDI_FAILED_LOADING(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableCDI_FAILED_LOADING(arg0, arg1));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
