/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.weld.se;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.glassfish.jersey.ext.cdi1x.internal.JerseyVetoed;
import org.glassfish.jersey.server.spi.ExternalRequestContext;
import org.glassfish.jersey.server.spi.ExternalRequestScope;
import org.jboss.weld.context.bound.BoundRequestContext;

@ApplicationScoped
@JerseyVetoed
public class WeldRequestScope
implements ExternalRequestScope<Map<String, Object>> {
    @Inject
    private BoundRequestContext context;
    private final ThreadLocal<Map<String, Object>> actualMap = new ThreadLocal();

    public ExternalRequestContext<Map<String, Object>> open() {
        ConcurrentHashMap newMap = new ConcurrentHashMap();
        this.actualMap.set(newMap);
        this.context.associate(newMap);
        this.context.activate();
        return new ExternalRequestContext(newMap);
    }

    public void resume(ExternalRequestContext<Map<String, Object>> ctx) {
        Map newMap = (Map)ctx.getContext();
        this.actualMap.set(newMap);
        this.context.associate((Object)newMap);
        this.context.activate();
    }

    public void suspend(ExternalRequestContext<Map<String, Object>> ctx) {
        try {
            Map<String, Object> contextMap = this.actualMap.get();
            if (contextMap != null) {
                this.context.deactivate();
                this.context.dissociate(contextMap);
            }
        }
        finally {
            this.actualMap.remove();
        }
    }

    public void close() {
        try {
            Map<String, Object> contextMap = this.actualMap.get();
            if (contextMap != null) {
                this.context.invalidate();
                this.context.deactivate();
                this.context.dissociate(contextMap);
            } else {
                this.context.deactivate();
            }
        }
        finally {
            this.actualMap.remove();
        }
    }
}

