/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.metadata.ElementDescriptor;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.server.validation.ValidationError;

@Priority(value=5000)
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    @Context
    private Configuration config;
    @Context
    private Provider<Request> request;

    public Response toResponse(ConstraintViolationException exception) {
        Response.ResponseBuilder response = Response.status((Response.Status)this.getStatus(exception));
        Object property = this.config.getProperty("jersey.config.server.validation.enableOutputValidationErrorEntity");
        if (property != null && Boolean.valueOf(property.toString()).booleanValue()) {
            List variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
            MediaType mediaType = ((Request)this.request.get()).selectVariant(variants).getMediaType();
            response.type(mediaType);
            response.entity((Object)new GenericEntity(this.getEntity(exception.getConstraintViolations()), new GenericType<List<ValidationError>>(){}.getType()));
        }
        return response.build();
    }

    private List<ValidationError> getEntity(Set<ConstraintViolation<?>> violations) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (ConstraintViolation<?> violation : violations) {
            errors.add(new ValidationError(violation.getMessage(), violation.getMessageTemplate(), this.getPath(violation), this.getInvalidValue(violation.getInvalidValue())));
        }
        return errors;
    }

    private String getInvalidValue(Object invalidValue) {
        if (invalidValue == null) {
            return null;
        }
        if (invalidValue.getClass().isArray()) {
            return Arrays.toString((Object[])invalidValue);
        }
        return invalidValue.toString();
    }

    private Response.Status getStatus(ConstraintViolationException exception) {
        return this.getResponseStatus(exception.getConstraintViolations());
    }

    private Response.Status getResponseStatus(Set<ConstraintViolation<?>> constraintViolations) {
        Iterator<ConstraintViolation<?>> iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            return this.getResponseStatus(iterator.next());
        }
        return Response.Status.BAD_REQUEST;
    }

    private Response.Status getResponseStatus(ConstraintViolation<?> constraintViolation) {
        for (Path.Node node : constraintViolation.getPropertyPath()) {
            ElementDescriptor.Kind kind = node.getElementDescriptor().getKind();
            if (!ElementDescriptor.Kind.RETURN_VALUE.equals((Object)kind)) continue;
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.BAD_REQUEST;
    }

    private String getPath(ConstraintViolation violation) {
        String leafBeanName = violation.getLeafBean().getClass().getSimpleName();
        String propertyPath = violation.getPropertyPath().toString();
        return leafBeanName + (!"".equals(propertyPath) ? '.' + propertyPath : "");
    }
}

