/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ExecutableValidator;
import javax.validation.executable.ValidateExecutable;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.model.Invocable;

public class ConfiguredValidatorImpl
implements ConfiguredValidator {
    private final Validator delegate;
    private final Configuration configuration;
    private final ConcurrentMap<Method, Boolean> validateMethodCache = Maps.newConcurrentMap();

    ConfiguredValidatorImpl(Validator delegate, Configuration configuration) {
        this.delegate = delegate;
        this.configuration = configuration;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.delegate.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.delegate.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.delegate.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.delegate.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.delegate.unwrap(type);
    }

    public ExecutableValidator forExecutables() {
        return this.delegate.forExecutables();
    }

    public void validateResourceAndInputParams(Object resource, Invocable resourceMethod, Object[] args) {
        HashSet constraintViolations = Sets.newHashSet();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            constraintViolations.addAll(this.validate(resource, new Class[0]));
        }
        if (beanDescriptor.hasConstrainedExecutables()) {
            Method validationMethod = resourceMethod.getValidateMethod();
            Method handlingMethod = resourceMethod.getHandlingMethod();
            MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod(validationMethod.getName(), (Class[])validationMethod.getParameterTypes());
            if (methodDescriptor != null && methodDescriptor.areParametersConstrained() && this.validateMethod(resource.getClass(), handlingMethod, validationMethod)) {
                constraintViolations.addAll(this.forExecutables().validateParameters(resource, validationMethod, args, new Class[0]));
            }
        }
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException((Set)constraintViolations);
        }
    }

    public void validateResult(Object resource, Invocable resourceMethod, Object result) {
        HashSet constraintViolations = Sets.newHashSet();
        Method validationMethod = resourceMethod.getValidateMethod();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.hasConstrainedExecutables()) {
            Method handlingMethod = resourceMethod.getHandlingMethod();
            MethodDescriptor methodDescriptor = beanDescriptor.getConstraintsForMethod(validationMethod.getName(), (Class[])validationMethod.getParameterTypes());
            if (methodDescriptor != null && methodDescriptor.isReturnValueConstrained() && this.validateMethod(resource.getClass(), handlingMethod, validationMethod)) {
                constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, validationMethod, result, new Class[0]));
                if (result instanceof Response) {
                    constraintViolations.addAll(this.forExecutables().validateReturnValue(resource, validationMethod, ((Response)result).getEntity(), new Class[0]));
                }
            }
            if (!constraintViolations.isEmpty()) {
                throw new ConstraintViolationException((Set)constraintViolations);
            }
        }
    }

    private boolean validateMethod(Class<?> clazz, Method method, Method validationMethod) {
        if (!this.validateMethodCache.containsKey(validationMethod)) {
            for (Class<?> overriddenClass : this.getValidationClassHierarchy(clazz)) {
                Method overriddenMethod = ReflectionHelper.findMethodOnClass(overriddenClass, (Method)method);
                if (overriddenMethod == null) continue;
                ExecutableType[] executableTypes = this.getExecutableTypes(overriddenMethod);
                if (executableTypes != null) {
                    this.validateMethodCache.putIfAbsent(validationMethod, this.validateMethod(overriddenMethod, executableTypes));
                    break;
                }
                executableTypes = this.getExecutableTypes(overriddenClass);
                if (executableTypes == null) continue;
                this.validateMethodCache.putIfAbsent(validationMethod, this.validateMethod(overriddenMethod, executableTypes));
                break;
            }
            this.validateMethodCache.putIfAbsent(validationMethod, this.validateMethod(method, this.configuration.getBootstrapConfiguration().getValidatedExecutableTypes()));
        }
        return (Boolean)this.validateMethodCache.get(validationMethod);
    }

    private boolean validateMethod(Method method, ExecutableType ... executableTypes) {
        return this.validateMethod(method, Sets.newHashSet((Object[])executableTypes));
    }

    private boolean validateMethod(Method method, Set<ExecutableType> executableTypes) {
        if (executableTypes.contains(ExecutableType.ALL)) {
            return true;
        }
        return ReflectionHelper.isGetter((Method)method) ? executableTypes.contains(ExecutableType.GETTER_METHODS) : executableTypes.contains(ExecutableType.NON_GETTER_METHODS);
    }

    private ExecutableType[] getExecutableTypes(AnnotatedElement element) {
        ValidateExecutable validateExecutable = element.getAnnotation(ValidateExecutable.class);
        return validateExecutable != null ? validateExecutable.value() : null;
    }

    private List<Class<?>> getValidationClassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = Lists.newArrayList();
        for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            hierarchy.add(clazz);
        }
        hierarchy.addAll(this.getAllValidationInterfaces(clazz));
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    private List<Class<?>> getAllValidationInterfaces(Class<?> clazz) {
        ListMultimap map = Multimaps.newListMultimap((Map)Maps.newTreeMap(), (Supplier)new Supplier<List<Class<?>>>(){

            public List<Class<?>> get() {
                return Lists.newArrayList();
            }
        });
        this.retrieveAllValidationInterfaces(clazz, (Multimap<Integer, Class<?>>)map);
        ArrayList interfaces = Lists.newArrayList((Iterable)map.values());
        Collections.reverse(interfaces);
        return interfaces;
    }

    private int retrieveAllValidationInterfaces(Class<?> clazz, Multimap<Integer, Class<?>> map) {
        if (clazz == null) {
            return 0;
        }
        int minDepth = 0;
        while (clazz != null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                int depth = this.retrieveAllValidationInterfaces(iface, map);
                if (!map.containsValue(iface)) {
                    map.put((Object)depth, iface);
                }
                minDepth = minDepth > depth ? depth : minDepth;
            }
            clazz = clazz.getSuperclass();
        }
        return minDepth + 1;
    }
}

