/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.validation.ValidationConfig;
import org.glassfish.jersey.server.validation.internal.ConfiguredValidatorImpl;
import org.glassfish.jersey.server.validation.internal.InjectingConstraintValidatorFactory;

public class ValidationBinder
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(DefaultConfigurationProvider.class, Singleton.class).to(Configuration.class).in(Singleton.class);
        this.bindFactory(DefaultValidatorFactoryProvider.class, Singleton.class).to(ValidatorFactory.class).in(Singleton.class);
        this.bindFactory(DefaultValidatorProvider.class, Singleton.class).to(Validator.class).in(Singleton.class);
        this.bindFactory(ConfiguredValidatorProvider.class, Singleton.class).to(ConfiguredValidator.class).in(PerLookup.class);
    }

    private static class ConfiguredValidatorProvider
    implements Factory<ConfiguredValidator> {
        @Inject
        private Configuration configuration;
        @Inject
        private ValidatorFactory factory;
        @Context
        private Providers providers;
        @Context
        private ResourceContext resourceContext;
        private ConfiguredValidator defaultValidator;
        private final WeakHashMap<ContextResolver<ValidationConfig>, ConfiguredValidator> validatorCache = new WeakHashMap();

        private ConfiguredValidatorProvider() {
        }

        public ConfiguredValidator provide() {
            ContextResolver contextResolver = this.providers.getContextResolver(ValidationConfig.class, MediaType.WILDCARD_TYPE);
            if (contextResolver == null) {
                return this.getDefaultValidator();
            }
            if (!this.validatorCache.containsKey(contextResolver)) {
                ValidatorContext context = this.getDefaultValidatorContext();
                ValidationConfig config = (ValidationConfig)contextResolver.getContext(ValidationConfig.class);
                if (config != null) {
                    if (config.getMessageInterpolator() != null) {
                        context.messageInterpolator(config.getMessageInterpolator());
                    }
                    if (config.getTraversableResolver() != null) {
                        context.traversableResolver(config.getTraversableResolver());
                    }
                    if (config.getConstraintValidatorFactory() != null) {
                        context.constraintValidatorFactory(config.getConstraintValidatorFactory());
                    }
                    if (config.getParameterNameProvider() != null) {
                        context.parameterNameProvider(config.getParameterNameProvider());
                    }
                }
                this.validatorCache.put((ContextResolver<ValidationConfig>)contextResolver, new ConfiguredValidatorImpl(context.getValidator(), this.configuration));
            }
            return this.validatorCache.get(contextResolver);
        }

        private ConfiguredValidator getDefaultValidator() {
            if (this.defaultValidator == null) {
                this.defaultValidator = new ConfiguredValidatorImpl(this.getDefaultValidatorContext().getValidator(), this.configuration);
            }
            return this.defaultValidator;
        }

        private ValidatorContext getDefaultValidatorContext() {
            ValidatorContext context = this.factory.usingContext();
            context.constraintValidatorFactory((ConstraintValidatorFactory)this.resourceContext.getResource(InjectingConstraintValidatorFactory.class));
            return context;
        }

        public void dispose(ConfiguredValidator instance) {
        }
    }

    private static class DefaultValidatorProvider
    implements Factory<Validator> {
        @Inject
        private ValidatorFactory factory;

        private DefaultValidatorProvider() {
        }

        public Validator provide() {
            return this.factory.getValidator();
        }

        public void dispose(Validator instance) {
        }
    }

    private static class DefaultValidatorFactoryProvider
    implements Factory<ValidatorFactory> {
        @Inject
        private Configuration config;

        private DefaultValidatorFactoryProvider() {
        }

        public ValidatorFactory provide() {
            return this.config.buildValidatorFactory();
        }

        public void dispose(ValidatorFactory instance) {
        }
    }

    private static class DefaultConfigurationProvider
    implements Factory<Configuration> {
        private final boolean inOsgi = ReflectionHelper.getOsgiRegistryInstance() != null;

        public Configuration provide() {
            if (!this.inOsgi) {
                return Validation.byDefaultProvider().configure();
            }
            return Validation.byDefaultProvider().providerResolver(new ValidationProviderResolver(){

                public List<ValidationProvider<?>> getValidationProviders() {
                    ArrayList validationProviders = new ArrayList();
                    for (ValidationProvider validationProvider : ServiceFinder.find(ValidationProvider.class)) {
                        validationProviders.add(validationProvider);
                    }
                    return validationProviders;
                }
            }).configure();
        }

        public void dispose(Configuration instance) {
        }
    }
}

