/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Configuration;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import org.glassfish.jersey.internal.util.ReflectionHelper;

class ValidateOnExecutionHandler {
    private final ConcurrentMap<Method, Boolean> validateMethodCache = Maps.newConcurrentMap();
    private final ConcurrentMap<Method, Boolean> validateGetterCache = Maps.newConcurrentMap();
    private final Configuration config;

    ValidateOnExecutionHandler(Configuration config) {
        this.config = config;
    }

    boolean validateGetter(Class<?> clazz, Method method) {
        if (!this.validateGetterCache.containsKey(method)) {
            this.processMethod(clazz, method, method);
        }
        return (Boolean)this.validateGetterCache.get(method);
    }

    boolean validateMethod(Class<?> clazz, Method method, Method validationMethod) {
        if (!this.validateMethodCache.containsKey(validationMethod)) {
            this.processMethod(clazz, method, validationMethod);
        }
        return (Boolean)this.validateMethodCache.get(validationMethod);
    }

    private void processMethod(Class<?> clazz, Method method, Method validationMethod) {
        for (Class<?> overriddenClass : this.getValidationClassHierarchy(clazz)) {
            Method overriddenMethod = ReflectionHelper.findMethodOnClass(overriddenClass, (Method)method);
            if (overriddenMethod == null) continue;
            Set<ExecutableType> executableTypes = this.getExecutableTypes(overriddenMethod);
            if (!executableTypes.isEmpty()) {
                boolean validateMethod = this.validateMethod(overriddenMethod, true, executableTypes);
                this.validateMethodCache.putIfAbsent(validationMethod, validateMethod);
                this.validateGetterCache.putIfAbsent(validationMethod, validateMethod);
                break;
            }
            executableTypes = this.getExecutableTypes(overriddenClass);
            if (executableTypes.isEmpty() || executableTypes.size() == 1 && executableTypes.contains(ExecutableType.IMPLICIT)) continue;
            boolean validateMethod = this.validateMethod(overriddenMethod, false, executableTypes);
            this.validateMethodCache.putIfAbsent(validationMethod, validateMethod);
            this.validateGetterCache.putIfAbsent(validationMethod, validateMethod);
            break;
        }
        if (!this.validateMethodCache.containsKey(validationMethod)) {
            Set defaultValidatedExecutableTypes = this.config.getBootstrapConfiguration().getDefaultValidatedExecutableTypes();
            boolean validateMethod = this.validateMethod(method, false, defaultValidatedExecutableTypes);
            this.validateGetterCache.putIfAbsent(validationMethod, validateMethod);
            this.validateMethodCache.putIfAbsent(validationMethod, ReflectionHelper.isGetter((Method)validationMethod) || validateMethod);
        }
    }

    private boolean validateMethod(Method method, boolean allowImplicit, Set<ExecutableType> executableTypes) {
        if (executableTypes.contains(ExecutableType.ALL) || allowImplicit && executableTypes.contains(ExecutableType.IMPLICIT)) {
            return true;
        }
        return ReflectionHelper.isGetter((Method)method) ? executableTypes.contains(ExecutableType.GETTER_METHODS) : executableTypes.contains(ExecutableType.NON_GETTER_METHODS);
    }

    private Set<ExecutableType> getExecutableTypes(AnnotatedElement element) {
        ValidateOnExecution validateExecutable = element.getAnnotation(ValidateOnExecution.class);
        return validateExecutable != null ? Sets.newHashSet((Object[])validateExecutable.type()) : Collections.emptySet();
    }

    private List<Class<?>> getValidationClassHierarchy(Class<?> clazz) {
        ArrayList hierarchy = Lists.newArrayList();
        for (Class<?> currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            hierarchy.add(clazz);
        }
        hierarchy.addAll(this.getAllValidationInterfaces(clazz));
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    private List<Class<?>> getAllValidationInterfaces(Class<?> clazz) {
        ListMultimap map = Multimaps.newListMultimap((Map)Maps.newTreeMap(), (Supplier)new Supplier<List<Class<?>>>(){

            public List<Class<?>> get() {
                return Lists.newArrayList();
            }
        });
        this.retrieveAllValidationInterfaces(clazz, (Multimap<Integer, Class<?>>)map);
        ArrayList interfaces = Lists.newArrayList((Iterable)map.values());
        Collections.reverse(interfaces);
        return interfaces;
    }

    private int retrieveAllValidationInterfaces(Class<?> clazz, Multimap<Integer, Class<?>> map) {
        if (clazz == null) {
            return 0;
        }
        int minDepth = 0;
        while (clazz != null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                int depth = this.retrieveAllValidationInterfaces(iface, map);
                if (!map.containsValue(iface)) {
                    map.put((Object)depth, iface);
                }
                minDepth = minDepth > depth ? depth : minDepth;
            }
            clazz = clazz.getSuperclass();
        }
        return minDepth + 1;
    }
}

