/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.validation.internal.ValidateOnExecutionHandler;

class ValidateOnExecutionTraversableResolver
implements TraversableResolver {
    private final TraversableResolver delegate;
    private final ConcurrentMap<String, Method> propertyToMethod = Maps.newConcurrentMap();
    private final ValidateOnExecutionHandler validateOnExecutionHandler;
    private final boolean validateExecutable;

    public ValidateOnExecutionTraversableResolver(TraversableResolver delegate, ValidateOnExecutionHandler validateOnExecutionHandler, boolean validateExecutable) {
        this.delegate = delegate;
        this.validateExecutable = validateExecutable;
        this.validateOnExecutionHandler = validateOnExecutionHandler;
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        Class<?> traversableObjectClass = traversableObject.getClass();
        if (this.validateExecutable && ElementType.METHOD.equals((Object)elementType)) {
            Method getter;
            String propertyName = traversableProperty.getName();
            String propertyKey = traversableObjectClass.getName() + "#" + propertyName;
            if (!this.propertyToMethod.containsKey(propertyKey)) {
                this.propertyToMethod.putIfAbsent(propertyKey, this.getGetterMethod(traversableObjectClass, propertyName));
            }
            return (getter = (Method)this.propertyToMethod.get(propertyKey)) != null && this.validateOnExecutionHandler.validateGetter(traversableObjectClass, getter);
        }
        return this.delegate.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.delegate.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private Method getGetterMethod(final Class<?> clazz, final String propertyName) {
        Class propertyType = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return clazz.getDeclaredField(propertyName).getType();
                }
                catch (SecurityException ex) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                return null;
            }
        });
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String getterPropertyName = new String(chars);
        String isGetter = "is" + getterPropertyName;
        String getGetter = "get" + getterPropertyName;
        for (Method method : clazz.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.equals(isGetter) && !methodName.equals(getGetter) || !ReflectionHelper.isGetter((Method)method) || propertyType != null && !propertyType.isAssignableFrom(method.getReturnType())) continue;
            return ReflectionHelper.findMethodOnClass(clazz, (Method)method);
        }
        return null;
    }
}

