/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import jakarta.inject.Provider;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.validation.ValidationError;
import org.glassfish.jersey.server.validation.internal.LocalizationMessages;
import org.glassfish.jersey.server.validation.internal.ValidationHelper;

public final class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger LOGGER = Logger.getLogger(ValidationExceptionMapper.class.getName());
    @Context
    private Configuration config;
    @Context
    private Provider<Request> request;

    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintViolationException) {
            LOGGER.log(Level.FINER, LocalizationMessages.CONSTRAINT_VIOLATIONS_ENCOUNTERED(), exception);
            ConstraintViolationException cve = (ConstraintViolationException)exception;
            Response.ResponseBuilder response = Response.status((Response.Status)ValidationHelper.getResponseStatus(cve));
            Object property = this.config.getProperty("jersey.config.beanValidation.enableOutputValidationErrorEntity.server");
            if (property != null && Boolean.valueOf(property.toString()).booleanValue()) {
                List variants = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.TEXT_PLAIN_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build();
                Variant variant = ((Request)this.request.get()).selectVariant(variants);
                if (variant != null) {
                    response.type(variant.getMediaType());
                } else {
                    response.type(MediaType.TEXT_PLAIN_TYPE);
                }
                response.entity((Object)new GenericEntity(ValidationHelper.constraintViolationToValidationErrors(cve), new GenericType<List<ValidationError>>(){}.getType()));
            }
            return response.build();
        }
        LOGGER.log(Level.WARNING, LocalizationMessages.VALIDATION_EXCEPTION_RAISED(), exception);
        return Response.serverError().entity((Object)exception.getMessage()).build();
    }
}

