
package org.glassfish.jersey.server.validation.internal.l10n;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.server.validation.internal.l10n.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableVALIDATION_EXCEPTION_RAISED() {
        return MESSAGE_FACTORY.getMessage("validation.exception.raised");
    }

    /**
     * Unexpected Bean Validation problem.
     * 
     */
    public static String VALIDATION_EXCEPTION_RAISED() {
        return LOCALIZER.localize(localizableVALIDATION_EXCEPTION_RAISED());
    }

    public static Localizable localizableOVERRIDE_CHECK_ERROR(Object arg0) {
        return MESSAGE_FACTORY.getMessage("override.check.error", arg0);
    }

    /**
     * Multiple ValidateOnExecution annotation definitions are hosted in the hierarchy of {0} method.
     * 
     */
    public static String OVERRIDE_CHECK_ERROR(Object arg0) {
        return LOCALIZER.localize(localizableOVERRIDE_CHECK_ERROR(arg0));
    }

    public static Localizable localizableVALIDATION_EXCEPTION_PROVIDER() {
        return MESSAGE_FACTORY.getMessage("validation.exception.provider");
    }

    /**
     * Failed to configure the default validation provider.
     * 
     */
    public static String VALIDATION_EXCEPTION_PROVIDER() {
        return LOCALIZER.localize(localizableVALIDATION_EXCEPTION_PROVIDER());
    }

    public static Localizable localizableCONSTRAINT_VIOLATIONS_ENCOUNTERED() {
        return MESSAGE_FACTORY.getMessage("constraint.violations.encountered");
    }

    /**
     * Following ConstraintViolations has been encountered.
     * 
     */
    public static String CONSTRAINT_VIOLATIONS_ENCOUNTERED() {
        return LOCALIZER.localize(localizableCONSTRAINT_VIOLATIONS_ENCOUNTERED());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
