/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking.mapping;

import java.lang.reflect.Type;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.model.HandlerConstructor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.glassfish.jersey.uri.PathPattern;
import org.glassfish.jersey.uri.UriTemplate;

public class NaiveResourceMappingContext
implements ResourceMappingContext {
    private ExtendedResourceContext erc;
    private Map<Class<?>, ResourceMappingContext.Mapping> mappings;

    public NaiveResourceMappingContext(@Context ExtendedResourceContext erc) {
        this.erc = erc;
    }

    @Override
    public ResourceMappingContext.Mapping getMapping(Class<?> resource) {
        this.buildMappings();
        return this.mappings.get(resource);
    }

    private void buildMappings() {
        if (this.mappings != null) {
            return;
        }
        this.mappings = new HashMap();
        this.erc.getResourceModel().accept(new ResourceModelVisitor(){
            StringBuffer prefix = new StringBuffer();
            Deque<PathPattern> stack = new LinkedList<PathPattern>();

            private void processComponents(ResourceModelComponent component) {
                List components = component.getComponents();
                if (components != null) {
                    for (ResourceModelComponent rc : components) {
                        rc.accept((ResourceModelVisitor)this);
                    }
                }
            }

            public void visitInvocable(Invocable invocable) {
                this.processComponents((ResourceModelComponent)invocable);
            }

            public void visitRuntimeResource(RuntimeResource runtimeResource) {
                this.processComponents((ResourceModelComponent)runtimeResource);
            }

            public void visitResourceModel(ResourceModel resourceModel) {
                this.processComponents((ResourceModelComponent)resourceModel);
            }

            public void visitResourceHandlerConstructor(HandlerConstructor handlerConstructor) {
                this.processComponents((ResourceModelComponent)handlerConstructor);
            }

            public void visitMethodHandler(MethodHandler methodHandler) {
                this.processComponents((ResourceModelComponent)methodHandler);
            }

            public void visitChildResource(Resource resource) {
                this.visitResourceIntl(resource, false);
            }

            public void visitResource(Resource resource) {
                this.visitResourceIntl(resource, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void visitResourceIntl(Resource resource, boolean isRoot) {
                try {
                    this.stack.addLast(resource.getPathPattern());
                    this.processComponents((ResourceModelComponent)resource);
                    if (isRoot) {
                        Class likelyToBeRoot = null;
                        for (Class next : resource.getHandlerClasses()) {
                            if (Inflector.class.isAssignableFrom(next)) continue;
                            likelyToBeRoot = next;
                        }
                        if (likelyToBeRoot != null) {
                            NaiveResourceMappingContext.this.mappings.put(likelyToBeRoot, NaiveResourceMappingContext.this.getMapping(this.getTemplate()));
                        }
                    }
                }
                finally {
                    this.stack.removeLast();
                }
            }

            public void visitResourceMethod(ResourceMethod resourceMethod) {
                if (resourceMethod.isExtended()) {
                    return;
                }
                if (ResourceMethod.JaxrsType.SUB_RESOURCE_LOCATOR.equals((Object)resourceMethod.getType()) && resourceMethod.getInvocable() != null) {
                    Invocable i = resourceMethod.getInvocable();
                    Type type = i.getResponseType();
                    StringBuilder template = this.getTemplate();
                    NaiveResourceMappingContext.this.mappings.put((Class)type, NaiveResourceMappingContext.this.getMapping(template));
                    Resource.Builder builder = Resource.builder((Class)i.getRawResponseType());
                    if (builder == null) {
                        builder = Resource.builder().path(resourceMethod.getParent().getPath());
                    }
                    Resource subResource = builder.build();
                    this.visitChildResource(subResource);
                }
                this.processComponents((ResourceModelComponent)resourceMethod);
            }

            private StringBuilder getTemplate() {
                StringBuilder template = new StringBuilder();
                for (PathPattern pp : this.stack) {
                    String ppTemplate = pp.getTemplate().getTemplate();
                    int tlength = template.length();
                    if (tlength > 0) {
                        if (template.charAt(tlength - 1) == '/') {
                            if (ppTemplate.startsWith("/")) {
                                template.append(ppTemplate, 1, ppTemplate.length());
                                continue;
                            }
                            template.append(ppTemplate);
                            continue;
                        }
                        if (ppTemplate.startsWith("/")) {
                            template.append(ppTemplate);
                            continue;
                        }
                        template.append("/");
                        template.append(ppTemplate);
                        continue;
                    }
                    template.append(ppTemplate);
                }
                return template;
            }
        });
    }

    private ResourceMappingContext.Mapping getMapping(final StringBuilder template) {
        return new ResourceMappingContext.Mapping(){
            UriTemplate uriTemplate;
            {
                this.uriTemplate = new UriTemplate(template.toString());
            }

            @Override
            public UriTemplate getTemplate() {
                return this.uriTemplate;
            }
        };
    }
}

