/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.linking.LinkELContext;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;
import org.glassfish.jersey.uri.internal.UriTemplateParser;

final class ELLinkBuilder {
    private static final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();

    private ELLinkBuilder() {
    }

    static boolean evaluateCondition(String condition, Object entity, Object resource, Object instance) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        LinkELContext context = new LinkELContext(entity, resource, instance);
        ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, condition, Boolean.TYPE);
        String result = expr.getValue((ELContext)context).toString();
        return "true".equals(result);
    }

    static URI buildURI(InjectLinkDescriptor link, Object entity, Object resource, Object instance, UriInfo uriInfo, ResourceMappingContext rmc) {
        String template = link.getLinkTemplate(rmc);
        LinkELContext context = new LinkELContext(entity, resource, instance);
        ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, template, String.class);
        template = expr.getValue((ELContext)context).toString();
        UriBuilder ub = ELLinkBuilder.applyLinkStyle(template, link.getLinkStyle(), uriInfo);
        UriTemplateParser parser = new UriTemplateParser(template);
        List parameterNames = parser.getNames();
        Map<String, Object> valueMap = ELLinkBuilder.getParameterValues(parameterNames, link, context);
        return ub.buildFromMap(valueMap);
    }

    private static UriBuilder applyLinkStyle(String template, InjectLink.Style style, UriInfo uriInfo) {
        UriBuilder ub = null;
        switch (style) {
            case ABSOLUTE: {
                ub = uriInfo.getBaseUriBuilder().path(template);
                break;
            }
            case ABSOLUTE_PATH: {
                String basePath = uriInfo.getBaseUri().getPath();
                ub = UriBuilder.fromPath((String)basePath).path(template);
                break;
            }
            case RELATIVE_PATH: {
                ub = UriBuilder.fromPath((String)template);
            }
        }
        return ub;
    }

    private static Map<String, Object> getParameterValues(List<String> parameterNames, InjectLinkDescriptor linkField, LinkELContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Iterator<String> iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String name;
            String elExpression = ELLinkBuilder.getEL(name = iterator.next(), linkField);
            ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, elExpression, String.class);
            Object value = expr.getValue((ELContext)context);
            values.put(name, value != null ? value.toString() : null);
        }
        return values;
    }

    private static String getEL(String name, InjectLinkDescriptor linkField) {
        String binding = linkField.getBinding(name);
        if (binding != null) {
            return binding;
        }
        return "${instance." + name + "}";
    }
}

