/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlTransient;
import org.glassfish.jersey.linking.ELLinkBuilder;
import org.glassfish.jersey.linking.EntityDescriptor;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.InjectLinkNoFollow;
import org.glassfish.jersey.linking.InjectLinksFieldDescriptor;
import org.glassfish.jersey.linking.LinkMessages;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;

class FieldProcessor<T> {
    private EntityDescriptor instanceDescriptor;
    private static final Logger log = Logger.getLogger(FieldProcessor.class.getName());

    public FieldProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    public void processLinks(T entity, UriInfo uriInfo, ResourceMappingContext rmc) {
        HashSet<Object> processed = new HashSet<Object>();
        Object resource = uriInfo.getMatchedResources().get(0);
        this.processLinks(entity, resource, entity, processed, uriInfo, rmc);
    }

    private void processLinks(Object entity, Object resource, Object instance, Set<Object> processed, UriInfo uriInfo, ResourceMappingContext rmc) {
        try {
            if (instance == null || processed.contains(instance)) {
                return;
            }
            if (instance.getClass().getPackage().getName().equals("java.lang")) {
                return;
            }
            processed.add(instance);
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, LinkMessages.WARNING_LINKFILTER_PROCESSING(instance.getClass().getName()), e);
        }
        for (FieldDescriptor field : this.instanceDescriptor.getLinkFields()) {
            if (field instanceof InjectLinkFieldDescriptor) {
                InjectLinkFieldDescriptor linkField = (InjectLinkFieldDescriptor)field;
                if (!ELLinkBuilder.evaluateCondition(linkField.getCondition(), entity, resource, instance)) continue;
                URI uri = ELLinkBuilder.buildURI(linkField, entity, resource, instance, uriInfo, rmc);
                linkField.setPropertyValue(instance, uri);
                continue;
            }
            if (!(field instanceof InjectLinksFieldDescriptor)) continue;
            Object[] linksField = (InjectLinksFieldDescriptor)field;
            ArrayList<Link> list = new ArrayList<Link>();
            for (InjectLinkFieldDescriptor linkField : linksField.getLinksToInject()) {
                if (!ELLinkBuilder.evaluateCondition(linkField.getCondition(), entity, resource, instance)) continue;
                URI uri = ELLinkBuilder.buildURI(linkField, entity, resource, instance, uriInfo, rmc);
                Link link = linkField.getLink(uri);
                list.add(link);
            }
            linksField.setPropertyValue(instance, list);
        }
        Class<?> instanceClass = instance.getClass();
        if (instanceClass.isArray() && Object[].class.isAssignableFrom(instanceClass)) {
            Object[] array;
            for (Object member : array = (Object[])instance) {
                this.processMember(entity, resource, member, processed, uriInfo, rmc);
            }
        } else if (instance instanceof Iterable) {
            Iterable iterable = (Iterable)instance;
            for (Object member : iterable) {
                this.processMember(entity, resource, member, processed, uriInfo, rmc);
            }
        }
        for (FieldDescriptor member : this.instanceDescriptor.getNonLinkFields()) {
            if (!this.fieldSuitableForIntrospection(member)) continue;
            this.processMember(entity, resource, member.getFieldValue(instance), processed, uriInfo, rmc);
        }
    }

    private boolean fieldSuitableForIntrospection(FieldDescriptor member) {
        return member.field == null || !member.field.isSynthetic() && !Modifier.isTransient(member.field.getModifiers()) && !member.field.getType().isPrimitive() && member.field.getType() != String.class && !member.field.isAnnotationPresent(InjectLinkNoFollow.class) && !member.field.isAnnotationPresent(XmlTransient.class);
    }

    private void processMember(Object entity, Object resource, Object member, Set<Object> processed, UriInfo uriInfo, ResourceMappingContext rmc) {
        if (member != null) {
            FieldProcessor proc = new FieldProcessor(member.getClass());
            super.processLinks(entity, resource, member, processed, uriInfo, rmc);
        }
    }
}

