/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.linking.ELLinkBuilder;
import org.glassfish.jersey.linking.EntityDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.LinkHeaderDescriptor;

class HeaderProcessor<T> {
    private EntityDescriptor instanceDescriptor;

    public HeaderProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    public void processLinkHeaders(T entity, UriInfo uriInfo, MultivaluedMap<String, Object> headers) {
        List<String> headerValues = this.getLinkHeaderValues(entity, uriInfo);
        for (String headerValue : headerValues) {
            headers.add((Object)"Link", (Object)headerValue);
        }
    }

    List<String> getLinkHeaderValues(Object entity, UriInfo uriInfo) {
        List matchedResources = uriInfo.getMatchedResources();
        if (!matchedResources.isEmpty()) {
            Object resource = matchedResources.get(0);
            ArrayList<String> headerValues = new ArrayList<String>();
            for (LinkHeaderDescriptor desc : this.instanceDescriptor.getLinkHeaders()) {
                if (!ELLinkBuilder.evaluateCondition(desc.getCondition(), entity, resource, entity)) continue;
                String headerValue = HeaderProcessor.getLinkHeaderValue(desc, entity, resource, uriInfo);
                headerValues.add(headerValue);
            }
            return headerValues;
        }
        return Collections.emptyList();
    }

    static String getLinkHeaderValue(LinkHeaderDescriptor desc, Object entity, Object resource, UriInfo uriInfo) {
        URI uri = ELLinkBuilder.buildURI(desc, entity, resource, entity, uriInfo);
        InjectLink link = desc.getLinkHeader();
        return InjectLink.Util.buildLinkFromUri(uri, link).toString();
    }
}

