/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.InjectLinks;

class InjectLinksFieldDescriptor
extends FieldDescriptor {
    private InjectLinks link;
    private Class<?> type;

    public InjectLinksFieldDescriptor(Field f, InjectLinks l, Class<?> t) {
        super(f);
        this.link = l;
        this.type = t;
    }

    public void setPropertyValue(Object instance, List<Link> list) {
        InjectLinksFieldDescriptor.setAccessibleField(this.field);
        try {
            Object[] value = null;
            if (List.class.equals(this.type)) {
                value = list;
            } else if (this.type.isArray()) {
                value = list.toArray((Object[])Array.newInstance(this.type.getComponentType(), list.size()));
            } else {
                throw new IllegalArgumentException("Field type " + this.type + " not one of supported List<Link> or List[]");
            }
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(InjectLinksFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(InjectLinksFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public InjectLinkFieldDescriptor[] getLinksToInject() {
        InjectLink[] listOfLinks = this.link.value();
        InjectLinkFieldDescriptor[] fields = new InjectLinkFieldDescriptor[listOfLinks.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new InjectLinkFieldDescriptor(this.field, listOfLinks[i], Link.class);
        }
        return fields;
    }
}

