/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.linking.LinkELContext;
import org.glassfish.jersey.uri.internal.UriTemplateParser;

class ELLinkBuilder {
    private static ExpressionFactory expressionFactory = ExpressionFactory.newInstance();

    ELLinkBuilder() {
    }

    public static boolean evaluateCondition(String condition, Object entity, Object resource, Object instance) {
        if (condition == null || condition.length() == 0) {
            return true;
        }
        LinkELContext context = new LinkELContext(entity, resource, instance);
        ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, condition, Boolean.TYPE);
        String result = expr.getValue((ELContext)context).toString();
        return result.equals("true");
    }

    public static URI buildURI(InjectLinkDescriptor link, Object entity, Object resource, Object instance, UriInfo uriInfo) {
        String template = link.getLinkTemplate();
        LinkELContext context = new LinkELContext(entity, resource, instance);
        ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, template, String.class);
        template = expr.getValue((ELContext)context).toString();
        UriBuilder ub = ELLinkBuilder.applyLinkStyle(template, link.getLinkStyle(), uriInfo);
        UriTemplateParser parser = new UriTemplateParser(template);
        List parameterNames = parser.getNames();
        Map<String, Object> valueMap = ELLinkBuilder.getParameterValues(parameterNames, link, context);
        URI uri = ub.buildFromMap(valueMap);
        return uri;
    }

    private static UriBuilder applyLinkStyle(String template, InjectLink.Style style, UriInfo uriInfo) {
        UriBuilder ub = null;
        switch (style) {
            case ABSOLUTE: {
                ub = uriInfo.getBaseUriBuilder().path(template);
                break;
            }
            case ABSOLUTE_PATH: {
                String basePath = uriInfo.getBaseUri().getPath();
                ub = UriBuilder.fromPath((String)basePath).path(template);
                break;
            }
            case RELATIVE_PATH: {
                ub = UriBuilder.fromPath((String)template);
            }
        }
        return ub;
    }

    private static Map<String, Object> getParameterValues(List<String> parameterNames, InjectLinkDescriptor linkField, LinkELContext context) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String name : parameterNames) {
            String elExpression = ELLinkBuilder.getEL(name, linkField);
            ValueExpression expr = expressionFactory.createValueExpression((ELContext)context, elExpression, String.class);
            Object value = expr.getValue((ELContext)context);
            values.put(name, value);
        }
        return values;
    }

    private static String getEL(String name, InjectLinkDescriptor linkField) {
        String binding = linkField.getBinding(name);
        if (binding != null) {
            return binding;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("${");
        builder.append("instance");
        builder.append(".");
        builder.append(name);
        builder.append("}");
        return builder.toString();
    }
}

