/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Link;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.glassfish.jersey.server.model.MethodList;

class InjectLinkFieldDescriptor
extends FieldDescriptor
implements InjectLinkDescriptor {
    private InjectLink link;
    private Class<?> type;
    private Map<String, String> bindings;

    public InjectLinkFieldDescriptor(Field f, InjectLink l, Class<?> t) {
        super(f);
        this.link = l;
        this.type = t;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : l.bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    public void setPropertyValue(Object instance, URI uri) {
        InjectLinkFieldDescriptor.setAccessibleField(this.field);
        try {
            Object value = null;
            if (URI.class.equals(this.type)) {
                value = uri;
            } else if (Link.class.isAssignableFrom(this.type)) {
                value = this.getLink(uri);
            } else if (String.class.equals(this.type)) {
                value = uri.toString();
            } else {
                throw new IllegalArgumentException("Field type " + this.type + " not one of supported String,URI and Link");
            }
            this.field.set(instance, value);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(InjectLinkFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(InjectLinkFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public InjectLink.Style getLinkStyle() {
        return this.link.style();
    }

    @Override
    public String getLinkTemplate() {
        return InjectLinkFieldDescriptor.getLinkTemplate(this.link);
    }

    public static String getLinkTemplate(InjectLink link) {
        String template = null;
        if (!link.resource().equals(Class.class)) {
            Path path = link.resource().getAnnotation(Path.class);
            String string = template = path == null ? "" : path.value();
            if (link.method().length() > 0) {
                MethodList methods = new MethodList(link.resource());
                methods = methods.withAnnotation(Path.class);
                for (AnnotatedMethod method : methods) {
                    if (!method.getMethod().getName().equals(link.method())) continue;
                    Path methodPath = (Path)method.getAnnotation(Path.class);
                    String methodTemplate = methodPath.value();
                    StringBuilder builder = new StringBuilder();
                    builder.append(template);
                    if (!template.endsWith("/") && !methodTemplate.startsWith("/")) {
                        builder.append("/");
                    }
                    builder.append(methodTemplate);
                    template = builder.toString();
                    break;
                }
            }
        } else {
            template = link.value();
        }
        return template;
    }

    public Link getLink(URI uri) {
        return InjectLink.Util.buildLinkFromUri(uri, this.link);
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.link.condition();
    }
}

