/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriInfo;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.linking.ELLinkBuilder;
import org.glassfish.jersey.linking.EntityDescriptor;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLinkFieldDescriptor;
import org.glassfish.jersey.linking.InjectLinkNoFollow;
import org.glassfish.jersey.linking.InjectLinksFieldDescriptor;
import org.glassfish.jersey.linking.LinkMessages;
import org.glassfish.jersey.linking.ProvideLinkDescriptor;
import org.glassfish.jersey.linking.contributing.ResourceLinkContributionContext;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;

class FieldProcessor<T> {
    private EntityDescriptor instanceDescriptor;
    private static final Logger log = Logger.getLogger(FieldProcessor.class.getName());

    FieldProcessor(Class<T> c) {
        this.instanceDescriptor = EntityDescriptor.getInstance(c);
    }

    void processLinks(T entity, UriInfo uriInfo, ResourceMappingContext rmc, ResourceLinkContributionContext rlcc) {
        HashSet<Object> processed = new HashSet<Object>();
        Object resource = uriInfo.getMatchedResources().get(0);
        this.processLinks(entity, resource, entity, processed, uriInfo, rmc, rlcc);
    }

    private void processLinks(Object entity, Object resource, Object instance, Set<Object> processed, UriInfo uriInfo, ResourceMappingContext rmc, ResourceLinkContributionContext rlcc) {
        try {
            if (instance == null || processed.contains(instance)) {
                return;
            }
            if (instance.getClass().getName().startsWith("java.lang")) {
                return;
            }
            processed.add(instance);
        }
        catch (RuntimeException e) {
            log.log(Level.INFO, LinkMessages.WARNING_LINKFILTER_PROCESSING(instance.getClass().getName()), e);
        }
        for (FieldDescriptor field : this.instanceDescriptor.getLinkFields()) {
            if (field instanceof InjectLinkFieldDescriptor) {
                InjectLinkFieldDescriptor linkField = (InjectLinkFieldDescriptor)field;
                if (!ELLinkBuilder.evaluateCondition(linkField.getCondition(), entity, resource, instance)) continue;
                URI uRI = ELLinkBuilder.buildURI(linkField, entity, resource, instance, uriInfo, rmc);
                linkField.setPropertyValue(instance, uRI);
                continue;
            }
            if (!(field instanceof InjectLinksFieldDescriptor)) continue;
            InjectLinksFieldDescriptor linksField = (InjectLinksFieldDescriptor)field;
            ArrayList<Link> arrayList = new ArrayList<Link>();
            for (InjectLinkFieldDescriptor linkField : linksField.getLinksToInject()) {
                if (!ELLinkBuilder.evaluateCondition(linkField.getCondition(), entity, resource, instance)) continue;
                URI uri = ELLinkBuilder.buildURI(linkField, entity, resource, instance, uriInfo, rmc);
                Link link = linkField.getLink(uri);
                arrayList.add(link);
            }
            List<ProvideLinkDescriptor> linkContributors = rlcc.getContributorsFor(instance.getClass());
            for (ProvideLinkDescriptor linkContributor : linkContributors) {
                if (!ELLinkBuilder.evaluateCondition(linkContributor.getCondition(), entity, linkContributor.getResource(), instance)) continue;
                URI uri = ELLinkBuilder.buildURI(linkContributor, entity, resource, instance, uriInfo, rmc);
                Link link = linkContributor.getLink(uri);
                arrayList.add(link);
            }
            linksField.setPropertyValue(instance, arrayList);
        }
        Class<?> instanceClass = instance.getClass();
        if (instanceClass.isArray() && Object[].class.isAssignableFrom(instanceClass)) {
            Object[] array = (Object[])instance;
            for (Object member : array) {
                this.processMember(entity, resource, member, processed, uriInfo, rmc, rlcc);
            }
        } else if (instance instanceof Iterable) {
            Iterable iterable = (Iterable)instance;
            for (Object e : iterable) {
                this.processMember(entity, resource, e, processed, uriInfo, rmc, rlcc);
            }
        } else if (instance instanceof Map) {
            Map map = (Map)instance;
            for (Object e : map.entrySet()) {
                this.processMember(entity, resource, e, processed, uriInfo, rmc, rlcc);
            }
        }
        for (FieldDescriptor member : this.instanceDescriptor.getNonLinkFields()) {
            if (!this.fieldSuitableForIntrospection(member)) continue;
            this.processMember(entity, resource, member.getFieldValue(instance), processed, uriInfo, rmc, rlcc);
        }
    }

    private boolean fieldSuitableForIntrospection(FieldDescriptor member) {
        return member.field == null || !member.field.isSynthetic() && !Modifier.isTransient(member.field.getModifiers()) && !member.field.getType().isPrimitive() && member.field.getType() != String.class && !member.field.isAnnotationPresent(InjectLinkNoFollow.class) && !member.field.isAnnotationPresent(XmlTransient.class);
    }

    private void processMember(Object entity, Object resource, Object member, Set<Object> processed, UriInfo uriInfo, ResourceMappingContext rmc, ResourceLinkContributionContext rlcc) {
        if (member != null) {
            FieldProcessor proc = new FieldProcessor(member.getClass());
            super.processLinks(entity, resource, member, processed, uriInfo, rmc, rlcc);
        }
    }
}

