/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.linking;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Link;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.linking.Binding;
import org.glassfish.jersey.linking.FieldDescriptor;
import org.glassfish.jersey.linking.InjectLink;
import org.glassfish.jersey.linking.InjectLinkDescriptor;
import org.glassfish.jersey.linking.mapping.ResourceMappingContext;
import org.glassfish.jersey.server.model.AnnotatedMethod;
import org.glassfish.jersey.server.model.MethodList;

class InjectLinkFieldDescriptor
extends FieldDescriptor
implements InjectLinkDescriptor {
    private InjectLink link;
    private Class<?> type;
    private Map<String, String> bindings;

    InjectLinkFieldDescriptor(Field f, InjectLink l, Class<?> t) {
        super(f);
        this.link = l;
        this.type = t;
        this.bindings = new HashMap<String, String>();
        for (Binding binding : l.bindings()) {
            this.bindings.put(binding.name(), binding.value());
        }
    }

    void setPropertyValue(Object instance, URI uri) {
        InjectLinkFieldDescriptor.setAccessibleField(this.field);
        try {
            Object value;
            if (Objects.equals(URI.class, this.type)) {
                value = uri;
            } else if (Link.class.isAssignableFrom(this.type)) {
                value = this.getLink(uri);
            } else if (Objects.equals(String.class, this.type)) {
                value = uri.toString();
            } else {
                throw new IllegalArgumentException("Field type " + this.type + " not one of supported String,URI and Link");
            }
            this.field.set(instance, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(InjectLinkFieldDescriptor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public InjectLink.Style getLinkStyle() {
        return this.link.style();
    }

    @Override
    public String getLinkTemplate(ResourceMappingContext rmc) {
        return InjectLinkFieldDescriptor.getLinkTemplate(rmc, this.link);
    }

    static String getLinkTemplate(ResourceMappingContext rmc, InjectLink link) {
        String template = null;
        if (Objects.equals(link.resource(), Class.class)) {
            template = link.value();
        } else {
            ResourceMappingContext.Mapping map = rmc.getMapping(link.resource());
            if (map != null) {
                template = map.getTemplate().getTemplate();
            } else {
                Path path = link.resource().getAnnotation(Path.class);
                String string = template = path == null ? "" : path.value();
            }
            if (!link.method().isEmpty()) {
                MethodList methods = new MethodList(link.resource());
                methods = methods.withMetaAnnotation(HttpMethod.class);
                for (AnnotatedMethod method : methods) {
                    StringBuilder querySubString;
                    if (!Objects.equals(method.getMethod().getName(), link.method())) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(template);
                    Path methodPath = (Path)method.getAnnotation(Path.class);
                    if (methodPath != null) {
                        String methodTemplate = methodPath.value();
                        if (!template.endsWith("/") && !methodTemplate.startsWith("/")) {
                            builder.append("/");
                        }
                        builder.append(methodTemplate);
                    }
                    if ((querySubString = InjectLinkFieldDescriptor.extractQueryParams(method)).length() > 0) {
                        builder.append("{?");
                        builder.append((CharSequence)querySubString);
                        builder.append("}");
                    }
                    template = builder.toString();
                    break;
                }
            }
        }
        return template;
    }

    static StringBuilder extractQueryParams(AnnotatedMethod method) throws SecurityException {
        StringBuilder querySubString = new StringBuilder();
        int parameterIndex = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] paramAnns;
            for (Annotation ann : paramAnns = annotationArray[i]) {
                Method[] beanMethods;
                Field[] fields;
                if (Objects.equals(ann.annotationType(), QueryParam.class)) {
                    querySubString.append(((QueryParam)ann).value());
                    querySubString.append(',');
                }
                if (!Objects.equals(ann.annotationType(), BeanParam.class)) continue;
                Class beanParamType = method.getParameterTypes()[parameterIndex];
                for (Field field : fields = beanParamType.getFields()) {
                    QueryParam queryParam = field.getAnnotation(QueryParam.class);
                    if (queryParam == null) continue;
                    querySubString.append(queryParam.value());
                    querySubString.append(',');
                }
                for (Method beanMethod : beanMethods = beanParamType.getMethods()) {
                    QueryParam queryParam = beanMethod.getAnnotation(QueryParam.class);
                    if (queryParam == null) continue;
                    querySubString.append(queryParam.value());
                    querySubString.append(',');
                }
            }
            ++parameterIndex;
        }
        return querySubString;
    }

    Link getLink(URI uri) {
        return InjectLink.Util.buildLinkFromUri(uri, this.link);
    }

    @Override
    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    @Override
    public String getCondition() {
        return this.link.condition();
    }
}

