/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.micrometer.server;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.glassfish.jersey.micrometer.server.DefaultJerseyObservationConvention;
import org.glassfish.jersey.micrometer.server.JerseyContext;
import org.glassfish.jersey.micrometer.server.JerseyObservationConvention;
import org.glassfish.jersey.micrometer.server.JerseyObservationDocumentation;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class ObservationRequestEventListener
implements RequestEventListener {
    private final Map<ContainerRequest, ObservationScopeAndContext> observations = Collections.synchronizedMap(new IdentityHashMap());
    private final ObservationRegistry registry;
    private final JerseyObservationConvention customConvention;
    private final String metricName;
    private final JerseyObservationConvention defaultConvention;

    public ObservationRequestEventListener(ObservationRegistry registry, String metricName) {
        this(registry, metricName, null);
    }

    public ObservationRequestEventListener(ObservationRegistry registry, String metricName, JerseyObservationConvention customConvention) {
        this.registry = Objects.requireNonNull(registry);
        this.metricName = Objects.requireNonNull(metricName);
        this.customConvention = customConvention;
        this.defaultConvention = new DefaultJerseyObservationConvention(this.metricName);
    }

    public void onEvent(RequestEvent event) {
        ContainerRequest containerRequest = event.getContainerRequest();
        switch (event.getType()) {
            case ON_EXCEPTION: {
                if (!this.isClientError(event) || this.observations.get(containerRequest) != null) break;
                this.startObservation(event);
                break;
            }
            case REQUEST_MATCHED: {
                this.startObservation(event);
                break;
            }
            case RESP_FILTERS_START: {
                ObservationScopeAndContext observationScopeAndContext = this.observations.get(containerRequest);
                if (observationScopeAndContext == null) break;
                observationScopeAndContext.jerseyContext.setResponse(event.getContainerResponse());
                observationScopeAndContext.jerseyContext.setRequestEvent(event);
                break;
            }
            case FINISHED: {
                ObservationScopeAndContext finishedObservation = this.observations.remove(containerRequest);
                if (finishedObservation == null) break;
                finishedObservation.jerseyContext.setRequestEvent(event);
                Observation.Scope observationScope = finishedObservation.observationScope;
                observationScope.close();
                observationScope.getCurrentObservation().stop();
                break;
            }
        }
    }

    private void startObservation(RequestEvent event) {
        JerseyContext jerseyContext = new JerseyContext(event);
        Observation observation = JerseyObservationDocumentation.DEFAULT.start(this.customConvention, this.defaultConvention, () -> jerseyContext, this.registry);
        Observation.Scope scope = observation.openScope();
        this.observations.put(event.getContainerRequest(), new ObservationScopeAndContext(scope, jerseyContext));
    }

    private boolean isClientError(RequestEvent event) {
        Throwable t = event.getException();
        if (t == null) {
            return false;
        }
        String className = t.getClass().getSuperclass().getCanonicalName();
        return className.equals("jakarta.ws.rs.ClientErrorException") || className.equals("javax.ws.rs.ClientErrorException");
    }

    private static class ObservationScopeAndContext {
        final Observation.Scope observationScope;
        final JerseyContext jerseyContext;

        ObservationScopeAndContext(Observation.Scope observationScope, JerseyContext jerseyContext) {
            this.observationScope = observationScope;
            this.jerseyContext = jerseyContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObservationScopeAndContext that = (ObservationScopeAndContext)o;
            return Objects.equals(this.observationScope, that.observationScope) && Objects.equals((Object)this.jerseyContext, (Object)that.jerseyContext);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.observationScope, this.jerseyContext});
        }
    }
}

