/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.freemarker;

import com.google.common.collect.Lists;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.DefaultTemplateProcessor;

final class FreemarkerViewProcessor
extends DefaultTemplateProcessor<String> {
    private final Configuration configuration = new Configuration();
    @Context
    private UriInfo uriInfo;

    public FreemarkerViewProcessor(@Context javax.ws.rs.core.Configuration config) {
        super(config);
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.setBasePathFromProperty("jersey.config.server.mvc.templateBasePath.freemarker");
    }

    public String resolve(String name, MediaType mediaType) {
        Class<?> lastMatchedResourceClass = this.getLastMatchedResourceClass();
        for (String templateName : this.getPossibleTemplateNames(name)) {
            if (lastMatchedResourceClass.getResource(templateName) == null) continue;
            return templateName;
        }
        return null;
    }

    protected List<String> getExtensions() {
        return Lists.newArrayList((Object[])new String[]{".ftl"});
    }

    public void writeTo(String templateReference, final Viewable viewable, MediaType mediaType, OutputStream out) throws IOException {
        out.flush();
        this.configuration.setClassForTemplateLoading(this.getLastMatchedResourceClass(), "/");
        Template template = this.configuration.getTemplate(templateReference);
        try {
            Object model = viewable.getModel();
            if (!(model instanceof Map)) {
                model = new HashMap<String, Object>(){
                    {
                        this.put("model", viewable.getModel());
                    }
                };
            }
            template.process(model, (Writer)new OutputStreamWriter(out));
        }
        catch (TemplateException te) {
            throw new ContainerException((Throwable)te);
        }
    }

    private Class<?> getLastMatchedResourceClass() {
        return this.uriInfo.getMatchedResources().get(0).getClass();
    }
}

