/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerConfigurationFactory;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerDefaultConfigurationFactory;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerSuppliedConfigurationFactory;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;

final class FreemarkerViewProcessor
extends AbstractTemplateProcessor<Template> {
    private final FreemarkerConfigurationFactory factory = (FreemarkerConfigurationFactory)this.getTemplateObjectFactory(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0), FreemarkerConfigurationFactory.class, () -> {
        Configuration configuration = (Configuration)this.getTemplateObjectFactory(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0), Configuration.class, Values.empty());
        if (configuration == null) {
            return new FreemarkerDefaultConfigurationFactory((ServletContext)injectionManager.getInstance(ServletContext.class));
        }
        return new FreemarkerSuppliedConfigurationFactory(configuration);
    });

    @Inject
    public FreemarkerViewProcessor(javax.ws.rs.core.Configuration config, InjectionManager injectionManager) {
        super(config, (ServletContext)injectionManager.getInstance(ServletContext.class), "freemarker", new String[]{"ftl"});
    }

    protected Template resolve(String templateReference, Reader reader) throws Exception {
        return this.factory.getConfiguration().getTemplate(templateReference);
    }

    public void writeTo(Template template, final Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        try {
            Object model = viewable.getModel();
            if (!(model instanceof Map)) {
                model = new HashMap<String, Object>(){
                    {
                        this.put("model", viewable.getModel());
                    }
                };
            }
            Charset encoding = this.setContentType(mediaType, httpHeaders);
            template.process(model, (Writer)new OutputStreamWriter(out, encoding));
        }
        catch (TemplateException te) {
            throw new ContainerException((Throwable)te);
        }
    }
}

