/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.freemarker;

import com.google.common.collect.Lists;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.jvnet.hk2.annotations.Optional;

final class FreemarkerViewProcessor
extends AbstractTemplateProcessor<Template> {
    private final Configuration factory;

    @Inject
    public FreemarkerViewProcessor(javax.ws.rs.core.Configuration config, ServiceLocator serviceLocator, final @Optional ServletContext servletContext) {
        super(config, servletContext, "freemarker", new String[]{"ftl"});
        this.factory = (Configuration)this.getTemplateObjectFactory(serviceLocator, Configuration.class, (Value)new Value<Configuration>(){

            public Configuration get() {
                ArrayList loaders = Lists.newArrayList();
                if (servletContext != null) {
                    loaders.add(new WebappTemplateLoader(servletContext));
                }
                loaders.add(new ClassTemplateLoader(FreemarkerViewProcessor.class, "/"));
                try {
                    loaders.add(new FileTemplateLoader(new File("/")));
                }
                catch (IOException e) {
                    // empty catch block
                }
                Configuration configuration = new Configuration();
                configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(new TemplateLoader[loaders.size()])));
                return configuration;
            }
        });
    }

    protected Template resolve(String templateReference, Reader reader) throws Exception {
        return this.factory.getTemplate(templateReference);
    }

    public void writeTo(Template template, final Viewable viewable, MediaType mediaType, OutputStream out) throws IOException {
        try {
            Object model = viewable.getModel();
            if (!(model instanceof Map)) {
                model = new HashMap<String, Object>(){
                    {
                        this.put("model", viewable.getModel());
                    }
                };
            }
            template.process(model, (Writer)new OutputStreamWriter(out));
        }
        catch (TemplateException te) {
            throw new ContainerException((Throwable)te);
        }
    }
}

