/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.jsp.internal;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.DefaultTemplateProcessor;
import org.glassfish.jersey.server.mvc.jsp.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.jsp.internal.RequestDispatcherWrapper;

public class JspTemplateProcessor
extends DefaultTemplateProcessor<String> {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(JspTemplateProcessor.class.getName()), Level.FINEST);
    @Context
    private ServletContext servletContext;
    @Inject
    private Provider<Ref<HttpServletRequest>> requestProviderRef;
    @Inject
    private Provider<Ref<HttpServletResponse>> responseProviderRef;
    @Inject
    private Provider<ContainerRequest> containerRequestProvider;

    public JspTemplateProcessor(@Context Configuration config) {
        super(config);
        this.setBasePathFromProperty("jersey.config.server.mvc.templateBasePath.jsp");
    }

    public String resolve(String name, MediaType mediaType) {
        if (this.servletContext == null) {
            return null;
        }
        try {
            for (String templateName : this.getPossibleTemplateNames(name)) {
                if (this.servletContext.getResource(templateName) == null) continue;
                return templateName;
            }
        }
        catch (MalformedURLException ex) {
            logger.log(Level.FINE, LocalizationMessages.RESOURCE_PATH_NOT_IN_CORRECT_FORM(this.getTemplateName(name)));
        }
        return null;
    }

    protected List<String> getExtensions() {
        return Lists.newArrayList((Object[])new String[]{".jsp"});
    }

    public void writeTo(String templateReference, Viewable viewable, MediaType mediaType, final OutputStream out) throws IOException {
        RequestDispatcher dispatcher;
        TracingLogger tracingLogger = TracingLogger.getInstance((PropertiesDelegate)((ContainerRequest)this.containerRequestProvider.get()).getPropertiesDelegate());
        if (tracingLogger.isLogEnabled((TracingLogger.Event)MvcJspEvent.JSP_FORWARD)) {
            tracingLogger.log((TracingLogger.Event)MvcJspEvent.JSP_FORWARD, new Object[]{templateReference, viewable.getModel()});
        }
        if ((dispatcher = this.servletContext.getRequestDispatcher(templateReference)) == null) {
            throw new ContainerException(LocalizationMessages.NO_REQUEST_DISPATCHER_FOR_RESOLVED_PATH(templateReference));
        }
        dispatcher = new RequestDispatcherWrapper(dispatcher, this.getBasePath(), viewable);
        final ServletOutputStream responseStream = new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        final PrintWriter responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)responseStream));
        try {
            dispatcher.forward((ServletRequest)((Ref)this.requestProviderRef.get()).get(), (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)((Ref)this.responseProviderRef.get()).get()){

                public ServletOutputStream getOutputStream() throws IOException {
                    return responseStream;
                }

                public PrintWriter getWriter() throws IOException {
                    return responseWriter;
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException((Throwable)e);
        }
        finally {
            responseWriter.flush();
        }
    }

    private static enum MvcJspEvent implements TracingLogger.Event
    {
        JSP_FORWARD(TracingLogger.Level.SUMMARY, "MVC", "Forwarding view to JSP page [%s], model %s");

        private final TracingLogger.Level level;
        private final String category;
        private final String messageFormat;

        private MvcJspEvent(TracingLogger.Level level, String category, String messageFormat) {
            this.level = level;
            this.category = category;
            this.messageFormat = messageFormat;
        }

        public String category() {
            return this.category;
        }

        public TracingLogger.Level level() {
            return this.level;
        }

        public String messageFormat() {
            return this.messageFormat;
        }
    }
}

