/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.Function;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;

@Singleton
final class MustacheTemplateProcessor
extends AbstractTemplateProcessor<Mustache> {
    private final MustacheFactory factory;

    public MustacheTemplateProcessor(Configuration config, ServletContext servletContext, Function<Class<?>, ?> createInstance) {
        super(config, servletContext, "mustache", new String[]{"mustache"});
        this.factory = (MustacheFactory)this.getTemplateObjectFactory(createInstance, MustacheFactory.class, DefaultMustacheFactory::new);
    }

    protected Mustache resolve(String templatePath, Reader reader) {
        return this.factory.compile(reader, templatePath);
    }

    public void writeTo(Mustache mustache, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        Charset encoding = this.setContentType(mediaType, httpHeaders);
        mustache.execute((Writer)new OutputStreamWriter(out, encoding), viewable.getModel()).flush();
    }
}

