/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.DataStructures;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;
import org.jvnet.hk2.annotations.Optional;

@Provider
@Singleton
final class MustacheTemplateProcessor
implements TemplateProcessor<Mustache> {
    private static final String SUFFIX = ".mustache";
    private final ConcurrentMap<String, Mustache> cache;
    private final ServletContext servletContext;
    private final String basePath;
    private final MustacheFactory factory;

    @Inject
    public MustacheTemplateProcessor(Configuration config, @Optional ServletContext servletContext) {
        this.servletContext = servletContext;
        this.factory = new DefaultMustacheFactory();
        Map properties = config.getProperties();
        this.basePath = !properties.containsKey("jersey.config.server.mvc.templateBasePath.mustache") ? "" : (String)config.getProperty("jersey.config.server.mvc.templateBasePath.mustache");
        this.cache = PropertiesHelper.isProperty((Map)properties, (String)"jersey.config.server.mvc.caching.mustache.enabled") ? DataStructures.createConcurrentMap() : null;
    }

    public Mustache resolve(String name, MediaType mediaType) {
        if (this.cache != null) {
            if (!this.cache.containsKey(name)) {
                this.cache.putIfAbsent(name, this.resolve(name));
            }
            return (Mustache)this.cache.get(name);
        }
        return this.resolve(name);
    }

    private Mustache resolve(String name) {
        InputStream stream;
        String template = name.endsWith(SUFFIX) ? this.basePath + name : this.basePath + name + SUFFIX;
        InputStreamReader reader = null;
        if (this.servletContext != null) {
            stream = this.servletContext.getResourceAsStream(template);
            InputStreamReader inputStreamReader = reader = stream != null ? new InputStreamReader(stream) : null;
        }
        if (reader == null) {
            stream = this.getClass().getResourceAsStream(template);
            InputStreamReader inputStreamReader = reader = stream != null ? new InputStreamReader(stream) : null;
        }
        if (reader == null) {
            try {
                reader = new FileReader(template);
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
        return reader != null ? this.factory.compile((Reader)reader, name) : null;
    }

    public void writeTo(Mustache mustache, Viewable viewable, MediaType mediaType, OutputStream out) throws IOException {
        mustache.execute((Writer)new OutputStreamWriter(out), viewable.getModel()).flush();
    }
}

