/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.jvnet.hk2.annotations.Optional;

@Singleton
final class MustacheTemplateProcessor
extends AbstractTemplateProcessor<Mustache> {
    private final MustacheFactory factory;

    @Inject
    public MustacheTemplateProcessor(Configuration config, ServiceLocator serviceLocator, @Optional ServletContext servletContext) {
        super(config, servletContext, "mustache", new String[]{"mustache"});
        this.factory = (MustacheFactory)this.getTemplateObjectFactory(serviceLocator, MustacheFactory.class, (Value)new Value<MustacheFactory>(){

            public MustacheFactory get() {
                return new DefaultMustacheFactory();
            }
        });
    }

    protected Mustache resolve(String templatePath, Reader reader) {
        return this.factory.compile(reader, templatePath);
    }

    public void writeTo(Mustache mustache, Viewable viewable, MediaType mediaType, OutputStream out) throws IOException {
        mustache.execute((Writer)new OutputStreamWriter(out), viewable.getModel()).flush();
    }
}

