/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;

@Singleton
final class MustacheTemplateProcessor
extends AbstractTemplateProcessor<Mustache> {
    private final MustacheFactory factory = (MustacheFactory)this.getTemplateObjectFactory(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0), MustacheFactory.class, DefaultMustacheFactory::new);

    @Inject
    public MustacheTemplateProcessor(Configuration config, InjectionManager injectionManager) {
        super(config, (ServletContext)injectionManager.getInstance(ServletContext.class), "mustache", new String[]{"mustache"});
    }

    protected Mustache resolve(String templatePath, Reader reader) {
        return this.factory.compile(reader, templatePath);
    }

    public void writeTo(Mustache mustache, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        Charset encoding = this.setContentType(mediaType, httpHeaders);
        mustache.execute((Writer)new OutputStreamWriter(out, encoding), viewable.getModel()).flush();
    }
}

