/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.thymeleaf;

import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.spi.AbstractTemplateProcessor;
import org.glassfish.jersey.server.mvc.thymeleaf.ThymeleafConfigurationFactory;
import org.glassfish.jersey.server.mvc.thymeleaf.ThymeleafDefaultConfigurationFactory;
import org.glassfish.jersey.server.mvc.thymeleaf.ThymeleafSuppliedConfigurationFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

public final class ThymeleafViewProcessor
extends AbstractTemplateProcessor<TemplateEngine> {
    private final ThymeleafConfigurationFactory factory = (ThymeleafConfigurationFactory)this.getTemplateObjectFactory(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0), ThymeleafConfigurationFactory.class, () -> {
        ThymeleafConfigurationFactory configuration = (ThymeleafConfigurationFactory)this.getTemplateObjectFactory(arg_0 -> ((InjectionManager)injectionManager).createAndInitialize(arg_0), ThymeleafConfigurationFactory.class, Values.empty());
        if (configuration == null) {
            return new ThymeleafDefaultConfigurationFactory(config);
        }
        return new ThymeleafSuppliedConfigurationFactory(configuration);
    });

    @Inject
    public ThymeleafViewProcessor(Configuration config, InjectionManager injectionManager) {
        super(config, (ServletContext)injectionManager.getInstance(ServletContext.class), "thymeleaf", new String[]{"html"});
    }

    protected TemplateEngine resolve(String templatePath, Reader reader) throws Exception {
        return this.factory.getTemplateEngine();
    }

    public void writeTo(TemplateEngine templateEngine, Viewable viewable, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException {
        Context context = new Context();
        Object model = viewable.getModel();
        if (!(model instanceof Map)) {
            context.setVariable("model", viewable.getModel());
        } else {
            context.setVariables((Map)viewable.getModel());
        }
        if (context.containsVariable("lang")) {
            Object langValue = context.getVariable("lang");
            if (langValue instanceof Locale) {
                context.setLocale((Locale)langValue);
            } else if (langValue instanceof String) {
                Locale locale = Locale.forLanguageTag((String)langValue);
                context.setLocale(locale);
            }
        }
        Charset encoding = this.setContentType(mediaType, httpHeaders);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoding));
        templateEngine.process(viewable.getTemplateName(), (IContext)context, (Writer)writer);
    }
}

