/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.thymeleaf;

import jakarta.ws.rs.core.Configuration;
import java.util.Map;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.server.mvc.thymeleaf.ThymeleafConfigurationFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafDefaultConfigurationFactory
implements ThymeleafConfigurationFactory {
    private final Configuration config;
    private final TemplateEngine templateEngine;

    public ThymeleafDefaultConfigurationFactory(Configuration config) {
        this.config = config;
        this.templateEngine = this.initTemplateEngine();
    }

    @Override
    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    private ITemplateResolver getTemplateResolver() {
        Map properties = this.config.getProperties();
        Object basePath = (String)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.templateBasePath.thymeleaf", String.class, (Map)null);
        if (basePath == null) {
            basePath = (String)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.templateBasePath", (Object)"", (Map)null);
        }
        if (basePath != null && !((String)basePath).startsWith("/")) {
            basePath = "/" + (String)basePath;
        }
        String templateFileSuffix = (String)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.templateFileSuffix.thymeleaf", (Object)".html", (Map)null);
        String templateFileMode = (String)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.templateMode.thymeleaf", (Object)"HTML5", (Map)null);
        Boolean cacheEnabled = (Boolean)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.caching.thymeleaf", Boolean.class, (Map)null);
        if (cacheEnabled == null) {
            cacheEnabled = (Boolean)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.caching", (Object)false, (Map)null);
        }
        Long cacheLiveMs = (Long)PropertiesHelper.getValue((Map)properties, (String)"jersey.config.server.mvc.cacheTTLMs.thymeleaf", (Object)3600000L, (Map)null);
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix((String)basePath);
        templateResolver.setSuffix(templateFileSuffix);
        templateResolver.setTemplateMode(templateFileMode);
        templateResolver.setCacheTTLMs(cacheLiveMs);
        templateResolver.setCacheable(cacheEnabled.booleanValue());
        return templateResolver;
    }

    private TemplateEngine initTemplateEngine() {
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver(this.getTemplateResolver());
        return templateEngine;
    }

    private IMessageResolver getMessageResolver() {
        StandardMessageResolver messageResolver = new StandardMessageResolver();
        return messageResolver;
    }
}

