/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.mvc.internal;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.mvc.Template;
import org.glassfish.jersey.server.mvc.Viewable;
import org.glassfish.jersey.server.mvc.internal.ImplicitViewable;
import org.glassfish.jersey.server.mvc.internal.LocalizationMessages;
import org.glassfish.jersey.server.mvc.internal.TemplateHelper;
import org.glassfish.jersey.server.mvc.spi.ResolvedViewable;
import org.glassfish.jersey.server.mvc.spi.TemplateProcessor;
import org.glassfish.jersey.server.mvc.spi.ViewableContext;
import org.glassfish.jersey.server.mvc.spi.ViewableContextException;

@Provider
@ConstrainedTo(value=RuntimeType.SERVER)
final class ViewableMessageBodyWriter
implements MessageBodyWriter<Viewable> {
    @Inject
    private ServiceLocator serviceLocator;
    @Context
    private javax.inject.Provider<ExtendedUriInfo> extendedUriInfoProvider;
    @Context
    private javax.inject.Provider<ContainerRequest> requestProvider;
    @Context
    private javax.inject.Provider<ResourceInfo> resourceInfoProvider;

    ViewableMessageBodyWriter() {
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Viewable.class.isAssignableFrom(type);
    }

    public long getSize(Viewable viewable, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Viewable viewable, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Template template = TemplateHelper.getTemplateAnnotation(annotations);
        try {
            ResolvedViewable resolvedViewable = this.resolve(viewable, template);
            if (resolvedViewable == null) {
                throw new WebApplicationException((Throwable)new ProcessingException(LocalizationMessages.TEMPLATE_NAME_COULD_NOT_BE_RESOLVED(viewable.getTemplateName())), Response.Status.NOT_FOUND);
            }
            httpHeaders.putSingle((Object)"Content-Type", (Object)resolvedViewable.getMediaType());
            resolvedViewable.writeTo(entityStream);
        }
        catch (ViewableContextException vce) {
            throw new NotFoundException((Throwable)((Object)vce));
        }
    }

    private ResolvedViewable resolve(Viewable viewable, Template template) {
        if (viewable instanceof ResolvedViewable) {
            return (ResolvedViewable)viewable;
        }
        ViewableContext viewableContext = this.getViewableContext();
        Set<TemplateProcessor> templateProcessors = this.getTemplateProcessors();
        List<MediaType> producibleMediaTypes = TemplateHelper.getProducibleMediaTypes((ContainerRequest)this.requestProvider.get(), (ExtendedUriInfo)this.extendedUriInfoProvider.get(), null);
        if (viewable instanceof ImplicitViewable) {
            ImplicitViewable implicitViewable = (ImplicitViewable)viewable;
            for (String templateName : implicitViewable.getTemplateNames()) {
                Viewable simpleViewable = new Viewable(templateName, viewable.getModel(), viewable.getResolvingClass());
                ResolvedViewable resolvedViewable = this.resolve(simpleViewable, producibleMediaTypes, simpleViewable.getResolvingClass(), viewableContext, templateProcessors);
                if (resolvedViewable == null) continue;
                return resolvedViewable;
            }
        } else {
            return this.resolve(viewable, producibleMediaTypes, this.getResolvingClass(viewable, template, (ResourceInfo)this.resourceInfoProvider.get()), viewableContext, templateProcessors);
        }
        return null;
    }

    private ResolvedViewable resolve(Viewable viewable, List<MediaType> mediaTypes, Class<?> resolvingClass, ViewableContext viewableContext, Set<TemplateProcessor> templateProcessors) {
        for (TemplateProcessor templateProcessor : templateProcessors) {
            for (MediaType mediaType : mediaTypes) {
                ResolvedViewable resolvedViewable = viewableContext.resolveViewable(viewable, mediaType, resolvingClass, templateProcessor);
                if (resolvedViewable == null) continue;
                return resolvedViewable;
            }
        }
        return null;
    }

    private Set<TemplateProcessor> getTemplateProcessors() {
        LinkedHashSet templateProcessors = Sets.newLinkedHashSet();
        templateProcessors.addAll(Providers.getCustomProviders((ServiceLocator)this.serviceLocator, TemplateProcessor.class));
        templateProcessors.addAll(Providers.getProviders((ServiceLocator)this.serviceLocator, TemplateProcessor.class));
        return templateProcessors;
    }

    private ViewableContext getViewableContext() {
        Set customProviders = Providers.getCustomProviders((ServiceLocator)this.serviceLocator, ViewableContext.class);
        if (!customProviders.isEmpty()) {
            return (ViewableContext)customProviders.iterator().next();
        }
        return (ViewableContext)Providers.getProviders((ServiceLocator)this.serviceLocator, ViewableContext.class).iterator().next();
    }

    private Class<?> getResolvingClass(Viewable viewable, Template template, ResourceInfo resourceInfo) {
        Class<?> resolvingClass = viewable.getResolvingClass() != null ? viewable.getResolvingClass() : (template != null && !Object.class.equals(template.resolvingClass()) ? template.resolvingClass() : resourceInfo.getResourceClass());
        return resolvingClass;
    }
}

