
package org.glassfish.jersey.server.mvc.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.server.mvc.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableTEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL() {
        return messageFactory.getMessage("template.resolving.class.cannot.be.null");
    }

    /**
     * Resolving class MUST not be null.
     * 
     */
    public static String TEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL() {
        return localizer.localize(localizableTEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL());
    }

    public static Localizable localizableTEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL() {
        return messageFactory.getMessage("template.model.of.view.cannot.be.null");
    }

    /**
     * The model of the view MUST not be null.
     * 
     */
    public static String TEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL() {
        return localizer.localize(localizableTEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL());
    }

    public static Localizable localizableTEMPLATE_HANDLER_ALREADY_ENHANCED(Object arg0) {
        return messageFactory.getMessage("template.handler.already.enhanced", arg0);
    }

    /**
     * Handler class "{0}" has been already enhanced. Skipping enhancing handler instance.
     * 
     */
    public static String TEMPLATE_HANDLER_ALREADY_ENHANCED(Object arg0) {
        return localizer.localize(localizableTEMPLATE_HANDLER_ALREADY_ENHANCED(arg0));
    }

    public static Localizable localizableTEMPLATE_NAME_MUST_NOT_BE_NULL() {
        return messageFactory.getMessage("template.name.must.not.be.null");
    }

    /**
     * The template name MUST not be null.
     * 
     */
    public static String TEMPLATE_NAME_MUST_NOT_BE_NULL() {
        return localizer.localize(localizableTEMPLATE_NAME_MUST_NOT_BE_NULL());
    }

    public static Localizable localizableTEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("template.names.could.not.be.resolved", arg0, arg1, arg2);
    }

    /**
     * Neither of the template names ({0}) could be resolved to a fully qualified template name. (paths: {1}, media-types: {2})
     * 
     */
    public static String TEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableTEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(arg0, arg1, arg2));
    }

    public static Localizable localizableTEMPLATE_NAME_COULD_NOT_BE_RESOLVED(Object arg0) {
        return messageFactory.getMessage("template.name.could.not.be.resolved", arg0);
    }

    /**
     * The template name "{0}" could not be resolved to a fully qualified template name.
     * 
     */
    public static String TEMPLATE_NAME_COULD_NOT_BE_RESOLVED(Object arg0) {
        return localizer.localize(localizableTEMPLATE_NAME_COULD_NOT_BE_RESOLVED(arg0));
    }

    public static Localizable localizableTEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE() {
        return messageFactory.getMessage("template.no.matching.resource.available");
    }

    /**
     * There is no last matching resource available.
     * 
     */
    public static String TEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE() {
        return localizer.localize(localizableTEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE());
    }

}
