
package org.glassfish.jersey.server.mvc.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.server.mvc.internal.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableTEMPLATE_NAME_COULD_NOT_BE_RESOLVED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("template.name.could.not.be.resolved", arg0);
    }

    /**
     * The template name "{0}" could not be resolved to a fully qualified template name.
     * 
     */
    public static String TEMPLATE_NAME_COULD_NOT_BE_RESOLVED(Object arg0) {
        return LOCALIZER.localize(localizableTEMPLATE_NAME_COULD_NOT_BE_RESOLVED(arg0));
    }

    public static Localizable localizableTEMPLATE_RESOLVE_ERROR(Object arg0) {
        return MESSAGE_FACTORY.getMessage("template.resolve.error", arg0);
    }

    /**
     * An exception occurred during resolving the {0} template.
     * 
     */
    public static String TEMPLATE_RESOLVE_ERROR(Object arg0) {
        return LOCALIZER.localize(localizableTEMPLATE_RESOLVE_ERROR(arg0));
    }

    public static Localizable localizableTEMPLATE_ERROR_CLOSING_READER() {
        return MESSAGE_FACTORY.getMessage("template.error.closing.reader");
    }

    /**
     * File reader was not closed properly.
     * 
     */
    public static String TEMPLATE_ERROR_CLOSING_READER() {
        return LOCALIZER.localize(localizableTEMPLATE_ERROR_CLOSING_READER());
    }

    public static Localizable localizableTEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE() {
        return MESSAGE_FACTORY.getMessage("template.no.matching.resource.available");
    }

    /**
     * There is no last matching resource available.
     * 
     */
    public static String TEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE() {
        return LOCALIZER.localize(localizableTEMPLATE_NO_MATCHING_RESOURCE_AVAILABLE());
    }

    public static Localizable localizableTEMPLATE_NAME_MUST_NOT_BE_NULL() {
        return MESSAGE_FACTORY.getMessage("template.name.must.not.be.null");
    }

    /**
     * The template name MUST not be null.
     * 
     */
    public static String TEMPLATE_NAME_MUST_NOT_BE_NULL() {
        return LOCALIZER.localize(localizableTEMPLATE_NAME_MUST_NOT_BE_NULL());
    }

    public static Localizable localizableTEMPLATE_HANDLER_ALREADY_ENHANCED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("template.handler.already.enhanced", arg0);
    }

    /**
     * Handler class "{0}" has been already enhanced. Skipping enhancing handler instance.
     * 
     */
    public static String TEMPLATE_HANDLER_ALREADY_ENHANCED(Object arg0) {
        return LOCALIZER.localize(localizableTEMPLATE_HANDLER_ALREADY_ENHANCED(arg0));
    }

    public static Localizable localizableWRONG_TEMPLATE_OBJECT_FACTORY(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("wrong.template.object.factory", arg0, arg1);
    }

    /**
     * Provided template object factory class, {0}, is not assignable from required type {1}.
     * 
     */
    public static String WRONG_TEMPLATE_OBJECT_FACTORY(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableWRONG_TEMPLATE_OBJECT_FACTORY(arg0, arg1));
    }

    public static Localizable localizableTEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(Object arg0, Object arg1, Object arg2) {
        return MESSAGE_FACTORY.getMessage("template.names.could.not.be.resolved", arg0, arg1, arg2);
    }

    /**
     * Neither of the template names ({0}) could be resolved to a fully qualified template name. (paths: {1}, media-types: {2})
     * 
     */
    public static String TEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(Object arg0, Object arg1, Object arg2) {
        return LOCALIZER.localize(localizableTEMPLATE_NAMES_COULD_NOT_BE_RESOLVED(arg0, arg1, arg2));
    }

    public static Localizable localizableTEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL() {
        return MESSAGE_FACTORY.getMessage("template.model.of.view.cannot.be.null");
    }

    /**
     * The model of the view MUST not be null.
     * 
     */
    public static String TEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL() {
        return LOCALIZER.localize(localizableTEMPLATE_MODEL_OF_VIEW_CANNOT_BE_NULL());
    }

    public static Localizable localizableTEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL() {
        return MESSAGE_FACTORY.getMessage("template.resolving.class.cannot.be.null");
    }

    /**
     * Resolving class MUST not be null.
     * 
     */
    public static String TEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL() {
        return LOCALIZER.localize(localizableTEMPLATE_RESOLVING_CLASS_CANNOT_BE_NULL());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
