/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.proxy;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

class RequestParameters {
    private WebTarget newTarget;
    private final MultivaluedHashMap<String, Object> headers;
    private final LinkedList<Cookie> cookies;
    private final Form form;
    private static final List<Class<?>> PARAM_ANNOTATION_CLASSES = Arrays.asList(PathParam.class, QueryParam.class, HeaderParam.class, CookieParam.class, MatrixParam.class, FormParam.class, BeanParam.class);

    RequestParameters(WebTarget newTarget, MultivaluedMap<String, Object> headers, List<Cookie> cookies, Form form) {
        this.headers = new MultivaluedHashMap(headers);
        this.cookies = new LinkedList<Cookie>(cookies);
        this.form = new Form();
        this.form.asMap().putAll((Map)form.asMap());
        this.newTarget = newTarget;
    }

    void addParameter(Object value, Map<Class<?>, Annotation> anns) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Annotation ann = anns.get(PathParam.class);
        if (ann != null) {
            this.newTarget = this.newTarget.resolveTemplate(((PathParam)ann).value(), value);
        } else {
            ann = anns.get(QueryParam.class);
            if (ann != null) {
                this.newTarget = value instanceof Collection ? this.newTarget.queryParam(((QueryParam)ann).value(), this.convert((Collection)value, true)) : this.newTarget.queryParam(((QueryParam)ann).value(), new Object[]{this.encodeTemplate(value)});
            } else {
                ann = anns.get(HeaderParam.class);
                if (ann != null) {
                    if (value instanceof Collection) {
                        this.headers.addAll((Object)((HeaderParam)ann).value(), this.convert((Collection)value, false));
                    } else {
                        this.headers.addAll((Object)((HeaderParam)ann).value(), new Object[]{value});
                    }
                } else {
                    ann = anns.get(CookieParam.class);
                    if (ann != null) {
                        String name = ((CookieParam)ann).value();
                        if (value instanceof Collection) {
                            for (Object v : (Collection)value) {
                                Cookie c;
                                if (!(v instanceof Cookie)) {
                                    c = new Cookie(name, v.toString());
                                } else {
                                    c = (Cookie)v;
                                    if (!name.equals(((Cookie)v).getName())) {
                                        c = new Cookie(name, c.getValue(), c.getPath(), c.getDomain(), c.getVersion());
                                    }
                                }
                                this.cookies.add(c);
                            }
                        } else if (!(value instanceof Cookie)) {
                            this.cookies.add(new Cookie(name, value.toString()));
                        } else {
                            Cookie c = (Cookie)value;
                            if (!name.equals(((Cookie)value).getName())) {
                                this.cookies.add(new Cookie(name, c.getValue(), c.getPath(), c.getDomain(), c.getVersion()));
                            }
                        }
                    } else {
                        ann = anns.get(MatrixParam.class);
                        if (ann != null) {
                            this.newTarget = value instanceof Collection ? this.newTarget.matrixParam(((MatrixParam)ann).value(), this.convert((Collection)value, true)) : this.newTarget.matrixParam(((MatrixParam)ann).value(), new Object[]{this.encodeTemplate(value)});
                        } else {
                            ann = anns.get(FormParam.class);
                            if (ann != null) {
                                if (value instanceof Collection) {
                                    for (Object v : (Collection)value) {
                                        this.form.param(((FormParam)ann).value(), v.toString());
                                    }
                                } else {
                                    this.form.param(((FormParam)ann).value(), value.toString());
                                }
                            } else if (anns.get(BeanParam.class) != null) {
                                if (value instanceof Collection) {
                                    for (Object v : (Collection)value) {
                                        this.addBeanParameter(v);
                                    }
                                } else {
                                    this.addBeanParameter(value);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void addBeanParameter(Object beanParam) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Class<?> beanClass = beanParam.getClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getAllFields(fields, beanClass);
        for (Field field : fields) {
            Object value = null;
            HashMap anns = new HashMap();
            for (Annotation ann : field.getAnnotations()) {
                anns.put(ann.annotationType(), ann);
            }
            if (RequestParameters.hasAnyParamAnnotation(anns)) {
                value = field.get(beanParam);
            } else {
                for (PropertyDescriptor pd : Introspector.getBeanInfo(beanClass).getPropertyDescriptors()) {
                    if (!pd.getName().equals(field.getName()) || pd.getReadMethod() == null) continue;
                    for (Annotation ann : pd.getReadMethod().getAnnotations()) {
                        anns.put(ann.annotationType(), ann);
                    }
                    if (!RequestParameters.hasAnyParamAnnotation(anns)) continue;
                    value = pd.getReadMethod().invoke(beanParam, new Object[0]);
                }
            }
            if (value == null) continue;
            this.addParameter(value, anns);
        }
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            this.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private Object[] convert(Collection<?> value, boolean encode) {
        Object[] array = new Object[value.size()];
        int index = 0;
        for (Object o : value) {
            array[index++] = o == null ? o : (encode ? this.encodeTemplate(o) : o.toString());
        }
        return array;
    }

    private String encodeTemplate(Object notNull) {
        return notNull.toString().replace("{", "%7B").replace("}", "%7D");
    }

    public static boolean hasAnyParamAnnotation(Map<Class<?>, Annotation> anns) {
        for (Class<?> paramAnnotationClass : PARAM_ANNOTATION_CLASSES) {
            if (!anns.containsKey(paramAnnotationClass)) continue;
            return true;
        }
        return false;
    }

    WebTarget getNewTarget() {
        return this.newTarget;
    }

    MultivaluedHashMap<String, Object> getHeaders() {
        return this.headers;
    }

    LinkedList<Cookie> getCookies() {
        return this.cookies;
    }

    Form getForm() {
        return this.form;
    }
}

