/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.portability;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.glassfish.jersey.servlet.portability.LocalizationMessages;

public class PortableServletContainer
implements Filter,
Servlet {
    private static final String JERSEY_1_PREFIX = "jersey1#";
    private static final String JERSEY_2_PREFIX = "jersey2#";
    private final Servlet wrappedServlet;
    private final Filter wrappedFilter;
    private final String includePrefix;
    private final String excludePrefix;

    public PortableServletContainer() {
        Class<?> servletClass;
        boolean isJersey1 = false;
        try {
            servletClass = Class.forName("com.sun.jersey.spi.container.servlet.ServletContainer");
            isJersey1 = true;
        }
        catch (ClassNotFoundException e) {
            try {
                servletClass = Class.forName("org.glassfish.jersey.servlet.ServletContainer");
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(LocalizationMessages.JERSEY_NOT_AVAILABLE());
            }
        }
        try {
            this.wrappedServlet = (Servlet)servletClass.newInstance();
            this.wrappedFilter = (Filter)this.wrappedServlet;
        }
        catch (Exception e) {
            throw new RuntimeException(LocalizationMessages.JERSEY_CONTAINER_CANT_LOAD(), e);
        }
        this.includePrefix = isJersey1 ? JERSEY_1_PREFIX : JERSEY_2_PREFIX;
        this.excludePrefix = isJersey1 ? JERSEY_2_PREFIX : JERSEY_1_PREFIX;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.wrappedFilter.init((FilterConfig)new FilterConfigWrapper(filterConfig));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.wrappedFilter.doFilter(request, response, chain);
    }

    public void init(ServletConfig config) throws ServletException {
        this.wrappedServlet.init((ServletConfig)new ServletConfigWrapper(config));
    }

    public ServletConfig getServletConfig() {
        return this.wrappedServlet.getServletConfig();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.wrappedServlet.service(req, res);
    }

    public String getServletInfo() {
        return this.wrappedServlet.getServletInfo();
    }

    public void destroy() {
        this.wrappedServlet.destroy();
    }

    private class ServletConfigWrapper
    extends InitParamsWrapper
    implements ServletConfig {
        private final ServletConfig wrapped;

        ServletConfigWrapper(ServletConfig wrapped) {
            this.wrapped = wrapped;
            this.init();
        }

        @Override
        String getInitParamValue(String name) {
            return this.wrapped.getInitParameter(name);
        }

        @Override
        Enumeration getInitParamNames() {
            return this.wrapped.getInitParameterNames();
        }

        public String getServletName() {
            return this.wrapped.getServletName();
        }

        public ServletContext getServletContext() {
            return this.wrapped.getServletContext();
        }
    }

    private class FilterConfigWrapper
    extends InitParamsWrapper
    implements FilterConfig {
        private final FilterConfig wrapped;

        FilterConfigWrapper(FilterConfig wrapped) {
            this.wrapped = wrapped;
            this.init();
        }

        public String getFilterName() {
            return this.wrapped.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.wrapped.getServletContext();
        }

        @Override
        String getInitParamValue(String name) {
            return this.wrapped.getInitParameter(name);
        }

        @Override
        Enumeration getInitParamNames() {
            return this.wrapped.getInitParameterNames();
        }
    }

    private abstract class InitParamsWrapper {
        private final HashMap<String, String> filteredInitParams = new HashMap();

        private InitParamsWrapper() {
        }

        void init() {
            Enumeration e = this.getInitParamNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.getInitParamValue(name);
                if (name.startsWith(PortableServletContainer.this.includePrefix)) {
                    name = name.substring(PortableServletContainer.this.includePrefix.length());
                } else if (name.startsWith(PortableServletContainer.this.excludePrefix)) continue;
                this.filteredInitParams.put(name, value);
            }
        }

        abstract String getInitParamValue(String var1);

        abstract Enumeration getInitParamNames();

        public String getInitParameter(String name) {
            return this.filteredInitParams.get(name);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.filteredInitParams.keySet());
        }
    }
}

