
package org.glassfish.jersey.servlet.portability;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.servlet.portability.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableJERSEY_CONTAINER_CANT_LOAD() {
        return messageFactory.getMessage("jersey.container.cant.load");
    }

    /**
     * Unable to instantiate Jersey ServletContainer.
     * 
     */
    public static String JERSEY_CONTAINER_CANT_LOAD() {
        return localizer.localize(localizableJERSEY_CONTAINER_CANT_LOAD());
    }

    public static Localizable localizableJERSEY_NOT_AVAILABLE() {
        return messageFactory.getMessage("jersey.not.available");
    }

    /**
     * No Jersey runtime found on the application classpath.
     * 
     */
    public static String JERSEY_NOT_AVAILABLE() {
        return localizer.localize(localizableJERSEY_NOT_AVAILABLE());
    }

}
