
package org.glassfish.jersey.servlet.portability;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.servlet.portability.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableJERSEY_CONTAINER_CANT_LOAD() {
        return MESSAGE_FACTORY.getMessage("jersey.container.cant.load");
    }

    /**
     * Unable to instantiate Jersey ServletContainer.
     * 
     */
    public static String JERSEY_CONTAINER_CANT_LOAD() {
        return LOCALIZER.localize(localizableJERSEY_CONTAINER_CANT_LOAD());
    }

    public static Localizable localizableJERSEY_NOT_AVAILABLE() {
        return MESSAGE_FACTORY.getMessage("jersey.not.available");
    }

    /**
     * No Jersey runtime found on the application classpath.
     * 
     */
    public static String JERSEY_NOT_AVAILABLE() {
        return LOCALIZER.localize(localizableJERSEY_NOT_AVAILABLE());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
