/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.spring;

import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.jersey.hk2.HK2InjectionManager;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionResolver;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spring.AutowiredInjectResolver;
import org.glassfish.jersey.server.spring.LocalizationMessages;
import org.jvnet.hk2.spring.bridge.api.SpringBridge;
import org.jvnet.hk2.spring.bridge.api.SpringIntoHK2Bridge;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringComponentProvider
implements ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(SpringComponentProvider.class.getName());
    private static final String DEFAULT_CONTEXT_CONFIG_LOCATION = "applicationContext.xml";
    private static final String PARAM_CONTEXT_CONFIG_LOCATION = "contextConfigLocation";
    private static final String PARAM_SPRING_CONTEXT = "contextConfig";
    private volatile InjectionManager injectionManager;
    private volatile ApplicationContext ctx;

    public void initialize(InjectionManager injectionManager) {
        ServletContext sc;
        this.injectionManager = injectionManager;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CTX_LOOKUP_STARTED());
        }
        this.ctx = (sc = (ServletContext)injectionManager.getInstance(ServletContext.class)) != null ? WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc) : this.createSpringContext();
        if (this.ctx == null) {
            LOGGER.severe(LocalizationMessages.CTX_LOOKUP_FAILED());
            return;
        }
        LOGGER.config(LocalizationMessages.CTX_LOOKUP_SUCESSFUL());
        HK2InjectionManager hk2InjectionManager = (HK2InjectionManager)injectionManager;
        SpringBridge.getSpringBridge().initializeSpringBridge(hk2InjectionManager.getServiceLocator());
        SpringIntoHK2Bridge springBridge = (SpringIntoHK2Bridge)injectionManager.getInstance(SpringIntoHK2Bridge.class);
        springBridge.bridgeSpringBeanFactory((BeanFactory)this.ctx);
        AbstractBinder binder = new AbstractBinder(){

            protected void configure() {
                this.bind(new AutowiredInjectResolver(SpringComponentProvider.this.ctx)).to(InjectionResolver.class);
                ((InstanceBinding)this.bind(SpringComponentProvider.this.ctx).to(ApplicationContext.class)).named("SpringContext");
            }
        };
        injectionManager.register((Binder)binder);
        LOGGER.config(LocalizationMessages.SPRING_COMPONENT_PROVIDER_INITIALIZED());
    }

    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (this.ctx == null) {
            return false;
        }
        if (AnnotationUtils.findAnnotation(component, Component.class) != null) {
            String[] beanNames = this.ctx.getBeanNamesForType(component);
            if (beanNames == null || beanNames.length != 1) {
                LOGGER.severe(LocalizationMessages.NONE_OR_MULTIPLE_BEANS_AVAILABLE(component));
                return false;
            }
            String beanName = beanNames[0];
            Binding binding = Bindings.supplier((Supplier)new SpringManagedBeanFactory(this.ctx, this.injectionManager, beanName)).to(component).to(providerContracts);
            this.injectionManager.register(binding);
            LOGGER.config(LocalizationMessages.BEAN_REGISTERED(beanNames[0]));
            return true;
        }
        return false;
    }

    public void done() {
    }

    private ApplicationContext createSpringContext() {
        ApplicationHandler applicationHandler = (ApplicationHandler)this.injectionManager.getInstance(ApplicationHandler.class);
        ApplicationContext springContext = (ApplicationContext)applicationHandler.getConfiguration().getProperty(PARAM_SPRING_CONTEXT);
        if (springContext == null) {
            String contextConfigLocation = (String)applicationHandler.getConfiguration().getProperty(PARAM_CONTEXT_CONFIG_LOCATION);
            springContext = this.createXmlSpringConfiguration(contextConfigLocation);
        }
        return springContext;
    }

    private ApplicationContext createXmlSpringConfiguration(String contextConfigLocation) {
        if (contextConfigLocation == null) {
            contextConfigLocation = DEFAULT_CONTEXT_CONFIG_LOCATION;
        }
        this.ctx = new ClassPathXmlApplicationContext(new String[]{contextConfigLocation, "jersey-spring-applicationContext.xml"});
        return this.ctx;
    }

    private static class SpringManagedBeanFactory
    implements Supplier {
        private final ApplicationContext ctx;
        private final InjectionManager injectionManager;
        private final String beanName;

        private SpringManagedBeanFactory(ApplicationContext ctx, InjectionManager injectionManager, String beanName) {
            this.ctx = ctx;
            this.injectionManager = injectionManager;
            this.beanName = beanName;
        }

        public Object get() {
            Object bean = this.ctx.getBean(this.beanName);
            if (bean instanceof Advised) {
                try {
                    Object localBean = ((Advised)bean).getTargetSource().getTarget();
                    this.injectionManager.inject(localBean);
                }
                catch (Exception e) {
                    this.injectionManager.inject(bean);
                }
            } else {
                this.injectionManager.inject(bean);
            }
            return bean;
        }
    }
}

