
package org.glassfish.jersey.server.spring;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private static final String BUNDLE_NAME = "org.glassfish.jersey.server.spring.localization";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private LocalizationMessages() {
    }

    public static Localizable localizableNONE_OR_MULTIPLE_BEANS_AVAILABLE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("none.or.multiple.beans.available", arg0);
    }

    /**
     * None or multiple beans found in Spring context for type {0}, skipping the type.
     * 
     */
    public static String NONE_OR_MULTIPLE_BEANS_AVAILABLE(Object arg0) {
        return LOCALIZER.localize(localizableNONE_OR_MULTIPLE_BEANS_AVAILABLE(arg0));
    }

    public static Localizable localizableCTX_LOOKUP_STARTED() {
        return MESSAGE_FACTORY.getMessage("ctx.lookup.started");
    }

    /**
     * Spring context lookup started.
     * 
     */
    public static String CTX_LOOKUP_STARTED() {
        return LOCALIZER.localize(localizableCTX_LOOKUP_STARTED());
    }

    public static Localizable localizableREGISTERING_CTX_LOADER_LISTENER() {
        return MESSAGE_FACTORY.getMessage("registering.ctx.loader.listener");
    }

    /**
     * Registering Spring ContextLoaderListener
     * 
     */
    public static String REGISTERING_CTX_LOADER_LISTENER() {
        return LOCALIZER.localize(localizableREGISTERING_CTX_LOADER_LISTENER());
    }

    public static Localizable localizableNOT_IN_REQUEST_SCOPE() {
        return MESSAGE_FACTORY.getMessage("not.in.request.scope");
    }

    /**
     * Cannot ask for request attributes - request is not active anymore!
     * 
     */
    public static String NOT_IN_REQUEST_SCOPE() {
        return LOCALIZER.localize(localizableNOT_IN_REQUEST_SCOPE());
    }

    public static Localizable localizableSPRING_COMPONENT_PROVIDER_INITIALIZED() {
        return MESSAGE_FACTORY.getMessage("spring.component.provider.initialized");
    }

    /**
     * Spring component provider initialized.
     * 
     */
    public static String SPRING_COMPONENT_PROVIDER_INITIALIZED() {
        return LOCALIZER.localize(localizableSPRING_COMPONENT_PROVIDER_INITIALIZED());
    }

    public static Localizable localizableSKIPPING_CTX_LODAER_LISTENER_REGISTRATION() {
        return MESSAGE_FACTORY.getMessage("skipping.ctx.lodaer.listener.registration");
    }

    /**
     * Presuming Spring ContextLoaderListener was manually registered. Skipping context loader registration.
     * 
     */
    public static String SKIPPING_CTX_LODAER_LISTENER_REGISTRATION() {
        return LOCALIZER.localize(localizableSKIPPING_CTX_LODAER_LISTENER_REGISTRATION());
    }

    public static Localizable localizableCTX_LOOKUP_FAILED() {
        return MESSAGE_FACTORY.getMessage("ctx.lookup.failed");
    }

    /**
     * Spring context lookup failed, skipping spring component provider initialization.
     * 
     */
    public static String CTX_LOOKUP_FAILED() {
        return LOCALIZER.localize(localizableCTX_LOOKUP_FAILED());
    }

    public static Localizable localizableBEAN_REGISTERED(Object arg0) {
        return MESSAGE_FACTORY.getMessage("bean.registered", arg0);
    }

    /**
     * Spring managed bean, {0}, registered with HK2.
     * 
     */
    public static String BEAN_REGISTERED(Object arg0) {
        return LOCALIZER.localize(localizableBEAN_REGISTERED(arg0));
    }

    public static Localizable localizableNO_BEANS_FOUND_FOR_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("no.beans.found.for.type", arg0);
    }

    /**
     * No beans found. Resolution failed for type {0}.
     * 
     */
    public static String NO_BEANS_FOUND_FOR_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableNO_BEANS_FOUND_FOR_TYPE(arg0));
    }

    public static Localizable localizableCTX_LOOKUP_SUCESSFUL() {
        return MESSAGE_FACTORY.getMessage("ctx.lookup.sucessful");
    }

    /**
     * Spring context lookup done.
     * 
     */
    public static String CTX_LOOKUP_SUCESSFUL() {
        return LOCALIZER.localize(localizableCTX_LOOKUP_SUCESSFUL());
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
