/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.wadl.doclet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResourceDocType;
import org.glassfish.jersey.wadl.doclet.DocProcessor;
import org.glassfish.jersey.wadl.doclet.ResourceDoclet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DocletUtils {
    private static final Logger LOG = Logger.getLogger(DocletUtils.class.getName());

    DocletUtils() {
    }

    private static String[] getCDataElements(DocProcessor docProcessor) {
        String[] original = new String[]{"commentText"};
        if (docProcessor == null) {
            return original;
        }
        String[] cdataElements = docProcessor.getCDataElements();
        if (cdataElements == null || cdataElements.length == 0) {
            return original;
        }
        String[] result = (String[])DocletUtils.copyOf(original, original.length + cdataElements.length);
        for (int i = 0; i < cdataElements.length; ++i) {
            result[original.length + i] = cdataElements[i];
        }
        return result;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength) {
        Object[] copy = original.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static Class<?>[] getJAXBContextClasses(ResourceDocType result, DocProcessor docProcessor) {
        Class[] clazzes;
        if (docProcessor == null) {
            clazzes = new Class[1];
        } else {
            Class<?>[] requiredJaxbContextClasses = docProcessor.getRequiredJaxbContextClasses();
            if (requiredJaxbContextClasses != null) {
                clazzes = new Class[1 + requiredJaxbContextClasses.length];
                for (int i = 0; i < requiredJaxbContextClasses.length; ++i) {
                    clazzes[i + 1] = requiredJaxbContextClasses[i];
                }
            } else {
                clazzes = new Class[]{result.getClass()};
            }
        }
        return clazzes;
    }

    static boolean createOutputFile(String filePath, DocProcessor docProcessor, ResourceDocType result) {
        boolean bl;
        String[] cdataElements = DocletUtils.getCDataElements(docProcessor);
        Class[] classes = DocletUtils.getJAXBContextClasses(result, docProcessor);
        LOG.info("cdataElements " + Arrays.asList(cdataElements));
        LOG.info("classes " + Arrays.asList(classes));
        BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(new File(filePath).toPath(), new OpenOption[0]));
        try {
            JAXBContext c = JAXBContext.newInstance((Class[])classes);
            Marshaller m = c.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            m.marshal((Object)result, (Writer)sw);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sw.toString().getBytes()));
            for (String cdata : cdataElements) {
                NodeList nodes = document.getElementsByTagName(cdata);
                LOG.info(nodes.getLength() + " nodes found by " + cdata);
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    CDATASection cdataSection = document.createCDATASection(node.getTextContent());
                    node.setTextContent(null);
                    node.appendChild(cdataSection);
                }
                document.createCDATASection(cdata);
            }
            DOMSource source = new DOMSource(document);
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, streamResult);
            LOG.info("Wrote " + result + " in " + filePath);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not serialize ResourceDoc.", e);
                return false;
            }
        }
        ((OutputStream)out).close();
        return bl;
    }

    static String getLinkClass(String className, String field) {
        Object object;
        try {
            Field declaredField = Class.forName(className, false, Thread.currentThread().getContextClassLoader()).getDeclaredField(field);
            declaredField.setAccessible(true);
            object = declaredField.get(null);
            LOG.log(Level.FINE, "Got object " + object);
        }
        catch (Exception e) {
            LOG.info("Have classloader: " + ResourceDoclet.class.getClassLoader().getClass());
            LOG.info("Have thread classloader " + Thread.currentThread().getContextClassLoader().getClass());
            LOG.info("Have system classloader " + ClassLoader.getSystemClassLoader().getClass());
            LOG.log(Level.SEVERE, "Could not get field " + className, e);
            return null;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)stringWriter);
            String result = stringWriter.getBuffer().toString();
            LOG.log(Level.FINE, "Got marshalled output:\n" + result);
            return result;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could serialize bean to xml: " + object, e);
            return null;
        }
    }
}

