/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.wadl.doclet;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ResourceDocType;
import org.glassfish.jersey.wadl.doclet.DocProcessor;
import org.glassfish.jersey.wadl.doclet.ResourceDoclet;
import org.xml.sax.ContentHandler;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DocletUtils {
    private static final Logger LOG = Logger.getLogger(DocletUtils.class.getName());

    DocletUtils() {
    }

    private static String[] getCDataElements(DocProcessor docProcessor) {
        String[] original = new String[]{"ns1^commentText", "ns2^commentText", "^commentText"};
        if (docProcessor == null) {
            return original;
        }
        String[] cdataElements = docProcessor.getCDataElements();
        if (cdataElements == null || cdataElements.length == 0) {
            return original;
        }
        String[] result = (String[])DocletUtils.copyOf(original, original.length + cdataElements.length);
        for (int i = 0; i < cdataElements.length; ++i) {
            result[original.length + i] = cdataElements[i];
        }
        return result;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength) {
        Object[] copy = original.getClass() == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(original.getClass().getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static XMLSerializer getXMLSerializer(OutputStream os, String[] cdataElements) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(cdataElements);
        of.setPreserveSpace(true);
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(os);
        return serializer;
    }

    private static Class<?>[] getJAXBContextClasses(ResourceDocType result, DocProcessor docProcessor) {
        Class[] clazzes;
        if (docProcessor == null) {
            clazzes = new Class[1];
        } else {
            Class<?>[] requiredJaxbContextClasses = docProcessor.getRequiredJaxbContextClasses();
            if (requiredJaxbContextClasses != null) {
                clazzes = new Class[1 + requiredJaxbContextClasses.length];
                for (int i = 0; i < requiredJaxbContextClasses.length; ++i) {
                    clazzes[i + 1] = requiredJaxbContextClasses[i];
                }
            } else {
                clazzes = new Class[]{result.getClass()};
            }
        }
        return clazzes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean createOutputFile(String filePath, DocProcessor docProcessor, ResourceDocType result) {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));){
            Class[] clazzes = DocletUtils.getJAXBContextClasses(result, docProcessor);
            JAXBContext c = JAXBContext.newInstance((Class[])clazzes);
            Marshaller m = c.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            String[] cdataElements = DocletUtils.getCDataElements(docProcessor);
            XMLSerializer serializer = DocletUtils.getXMLSerializer(out, cdataElements);
            m.marshal((Object)result, (ContentHandler)serializer);
            LOG.info("Wrote " + result);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could not serialize ResourceDoc.", e);
            return false;
        }
    }

    static String getLinkClass(String className, String field) {
        Object object;
        try {
            Field declaredField = Class.forName(className, false, Thread.currentThread().getContextClassLoader()).getDeclaredField(field);
            declaredField.setAccessible(true);
            object = declaredField.get(null);
            LOG.log(Level.FINE, "Got object " + object);
        }
        catch (Exception e) {
            LOG.info("Have classloader: " + ResourceDoclet.class.getClassLoader().getClass());
            LOG.info("Have thread classloader " + Thread.currentThread().getContextClassLoader().getClass());
            LOG.info("Have system classloader " + ClassLoader.getSystemClassLoader().getClass());
            LOG.log(Level.SEVERE, "Could not get field " + className, e);
            return null;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)stringWriter);
            String result = stringWriter.getBuffer().toString();
            LOG.log(Level.FINE, "Got marshalled output:\n" + result);
            return result;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Could serialize bean to xml: " + object, e);
            return null;
        }
    }
}

