/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.config;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Feature;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.glassfish.jersey.spi.ExternalConfigurationModel;

public class ConfigurationModel<CONFIG extends Config>
implements ExternalConfigurationModel<CONFIG> {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final CONFIG config;

    public ConfigurationModel(CONFIG config) {
        this.config = config;
    }

    public <T> T as(String name, Class<T> clazz) {
        return (T)this.config.getValue(name, clazz);
    }

    public <T> Optional<T> getOptionalProperty(String name, Class<T> clazz) {
        return this.config.getOptionalValue(name, clazz);
    }

    public CONFIG getConfig() {
        return this.config;
    }

    public boolean isProperty(String name) {
        return this.properties.isEmpty() ? this.getValueFromConfig(name) != null : this.properties.containsKey(name);
    }

    public Object getValueFromConfig(String name) {
        return this.getConfig().getValue(name, Object.class);
    }

    public RuntimeType getRuntimeType() {
        return null;
    }

    public Map<String, Object> getProperties() {
        if (this.properties.isEmpty()) {
            this.config.getPropertyNames().forEach(c -> this.properties.put((String)c, this.config.getValue(c, String.class)));
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.properties.isEmpty() ? this.getValueFromConfig(name) : this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>(this.properties.keySet());
        if (names.isEmpty()) {
            this.config.getPropertyNames().forEach(names::add);
        }
        return names;
    }

    public ExternalConfigurationModel mergeProperties(Map<String, Object> inputProperties) {
        if (inputProperties == null || inputProperties.isEmpty()) {
            return this;
        }
        if (this.properties.isEmpty()) {
            this.getProperties();
        }
        this.properties.putAll(inputProperties);
        return this;
    }

    public boolean isEnabled(Feature feature) {
        return false;
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return false;
    }

    public boolean isRegistered(Object component) {
        return false;
    }

    public boolean isRegistered(Class<?> componentClass) {
        return false;
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        return null;
    }

    public Set<Class<?>> getClasses() {
        return null;
    }

    public Set<Object> getInstances() {
        return null;
    }
}

