/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;

class ExecutorServiceWrapper
implements ExecutorService {
    private final ExecutorService wrapped;
    private final List<AsyncInvocationInterceptor> asyncInterceptors;

    ExecutorServiceWrapper(ExecutorService wrapped, List<AsyncInvocationInterceptor> asyncInterceptors) {
        this.wrapped = wrapped;
        this.asyncInterceptors = asyncInterceptors;
    }

    @Override
    public void shutdown() {
        this.wrapped.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.wrapped.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.wrapped.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.wrapped.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrapped.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.wrapped.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.wrapped.submit(this.wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.wrapped.submit(this.wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.wrapped.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrapped.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.wrapped.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrapped.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.wrapped.execute(this.wrap(command));
    }

    private <T> Callable<T> wrap(Callable<T> task) {
        return () -> {
            this.asyncInterceptors.forEach(AsyncInvocationInterceptor::applyContext);
            return task.call();
        };
    }

    private Runnable wrap(Runnable task) {
        return () -> {
            this.asyncInterceptors.forEach(AsyncInvocationInterceptor::applyContext);
            task.run();
        };
    }

    private <T> Collection<? extends Callable<T>> wrap(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::wrap).collect(Collectors.toList());
    }
}

