/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.security.AccessController;

class ReflectionUtil {
    ReflectionUtil() {
    }

    static <T> T createInstance(Class<T> tClass) {
        return (T)AccessController.doPrivileged(() -> {
            try {
                return tClass.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("No default constructor in class " + tClass + " present. Class cannot be created!", t);
            }
        });
    }

    static <T> T createProxyInstance(Class<T> restClientClass) {
        return (T)AccessController.doPrivileged(() -> Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{restClientClass}, (proxy, m, args) -> {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(restClientClass)).in(restClientClass).unreflectSpecial(m, restClientClass).bindTo(proxy).invokeWithArguments(args);
        }));
    }
}

