/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;
import org.glassfish.jersey.client.Initializable;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InjectionManagerSupplier;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.microprofile.restclient.ConfigWrapper;
import org.glassfish.jersey.microprofile.restclient.DefaultResponseExceptionMapper;
import org.glassfish.jersey.microprofile.restclient.ExecutorServiceWrapper;
import org.glassfish.jersey.microprofile.restclient.ProxyInvocationHandler;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;
import org.glassfish.jersey.microprofile.restclient.RestClientModel;

class RestClientBuilderImpl
implements RestClientBuilder {
    private static final String CONFIG_DISABLE_DEFAULT_MAPPER = "microprofile.rest.client.disable.default.mapper";
    private static final String CONFIG_PROVIDERS = "/mp-rest/providers";
    private static final String CONFIG_PROVIDER_PRIORITY = "/priority";
    private static final String PROVIDER_SEPARATOR = ",";
    private final Set<ResponseExceptionMapper> responseExceptionMappers;
    private final Set<ParamConverterProvider> paramConverterProviders;
    private final List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories;
    private final Config config;
    private final ConfigWrapper configWrapper;
    private URI uri;
    private ClientBuilder clientBuilder = ClientBuilder.newBuilder();
    private Supplier<ExecutorService> executorService;

    RestClientBuilderImpl() {
        this.responseExceptionMappers = new HashSet<ResponseExceptionMapper>();
        this.paramConverterProviders = new HashSet<ParamConverterProvider>();
        this.asyncInterceptorFactories = new ArrayList<AsyncInvocationInterceptorFactory>();
        this.config = ConfigProvider.getConfig();
        this.configWrapper = new ConfigWrapper(this.clientBuilder.getConfiguration());
        this.executorService = Executors::newCachedThreadPool;
    }

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.uri = url.toURI();
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public RestClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.clientBuilder.connectTimeout(timeout, unit);
        return this;
    }

    public RestClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.clientBuilder.readTimeout(timeout, unit);
        return this;
    }

    public RestClientBuilder executorService(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException("ExecutorService cannot be null.");
        }
        this.executorService = () -> executor;
        return this;
    }

    public <T> T build(Class<T> interfaceClass) throws IllegalStateException, RestClientDefinitionException {
        if (this.uri == null) {
            throw new IllegalStateException("Base uri/url cannot be null!");
        }
        this.processProviders(interfaceClass);
        InjectionManagerExposer injectionManagerExposer = new InjectionManagerExposer();
        this.register(injectionManagerExposer);
        for (RestClientListener restClientListener : ServiceLoader.load(RestClientListener.class)) {
            restClientListener.onNewClient(interfaceClass, (RestClientBuilder)this);
        }
        this.registerExceptionMapper();
        List<AsyncInvocationInterceptor> asyncInterceptors = this.asyncInterceptorFactories.stream().map(AsyncInvocationInterceptorFactory::newInterceptor).collect(Collectors.toList());
        asyncInterceptors.forEach(AsyncInvocationInterceptor::prepareContext);
        this.clientBuilder.executorService((ExecutorService)new ExecutorServiceWrapper(this.executorService.get(), asyncInterceptors));
        Client client = this.clientBuilder.build();
        if (client instanceof Initializable) {
            ((Initializable)client).preInitialize();
        }
        WebTarget webTarget = client.target(this.uri);
        RestClientModel restClientModel = RestClientModel.from(interfaceClass, this.responseExceptionMappers, this.paramConverterProviders, asyncInterceptors, injectionManagerExposer.injectionManager, CdiUtil.getBeanManager());
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ProxyInvocationHandler(webTarget, restClientModel));
    }

    private void registerExceptionMapper() {
        Optional disableDefaultMapperConfig;
        Object disableDefaultMapperJersey = this.clientBuilder.getConfiguration().getProperty(CONFIG_DISABLE_DEFAULT_MAPPER);
        if (disableDefaultMapperJersey != null && disableDefaultMapperJersey.equals(Boolean.FALSE)) {
            this.register(new DefaultResponseExceptionMapper());
        } else if (!(disableDefaultMapperJersey != null || (disableDefaultMapperConfig = this.config.getOptionalValue(CONFIG_DISABLE_DEFAULT_MAPPER, Boolean.TYPE)).isPresent() && ((Boolean)disableDefaultMapperConfig.get()).booleanValue())) {
            this.register(new DefaultResponseExceptionMapper());
        }
    }

    private <T> void processProviders(Class<T> interfaceClass) {
        RegisterProvider[] registerProviders;
        Object providersFromJerseyConfig = this.clientBuilder.getConfiguration().getProperty(interfaceClass.getName() + CONFIG_PROVIDERS);
        if (providersFromJerseyConfig instanceof String && !((String)providersFromJerseyConfig).isEmpty()) {
            String[] providerArray = ((String)providersFromJerseyConfig).split(PROVIDER_SEPARATOR);
            this.processConfigProviders(interfaceClass, providerArray);
        }
        Optional providersFromConfig = this.config.getOptionalValue(interfaceClass.getName() + CONFIG_PROVIDERS, String.class);
        providersFromConfig.ifPresent(providers -> {
            if (!providers.isEmpty()) {
                String[] providerArray = ((String)providersFromConfig.get()).split(PROVIDER_SEPARATOR);
                this.processConfigProviders(interfaceClass, providerArray);
            }
        });
        for (RegisterProvider registerProvider : registerProviders = (RegisterProvider[])interfaceClass.getAnnotationsByType(RegisterProvider.class)) {
            this.register(registerProvider.value(), registerProvider.priority() < 0 ? 5000 : registerProvider.priority());
        }
    }

    private void processConfigProviders(Class<?> restClientInterface, String[] providerArray) {
        for (String provider : providerArray) {
            Class providerClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)provider));
            if (providerClass == null) {
                throw new IllegalStateException("No provider class with following name found: " + provider);
            }
            int priority = this.getProviderPriority(restClientInterface, providerClass);
            this.register(providerClass, priority);
        }
    }

    private int getProviderPriority(Class<?> restClientInterface, Class<?> providerClass) {
        Priority priority;
        String property = restClientInterface.getName() + CONFIG_PROVIDERS + "/" + providerClass.getName() + CONFIG_PROVIDER_PRIORITY;
        Object providerPriorityJersey = this.clientBuilder.getConfiguration().getProperty(property);
        if (providerPriorityJersey == null) {
            Optional providerPriorityMP = this.config.getOptionalValue(property, Integer.TYPE);
            if (providerPriorityMP.isPresent()) {
                return (Integer)providerPriorityMP.get();
            }
        } else if (providerPriorityJersey instanceof Integer) {
            return (Integer)providerPriorityJersey;
        }
        return (priority = providerClass.getAnnotation(Priority.class)) == null ? -1 : priority.value();
    }

    public Configuration getConfiguration() {
        return this.configWrapper;
    }

    public RestClientBuilder property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass) {
        if (this.isSupportedCustomProvider(componentClass)) {
            this.register(ReflectionUtil.createInstance(componentClass));
        } else {
            this.clientBuilder.register(componentClass);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, int priority) {
        if (this.isSupportedCustomProvider(componentClass)) {
            this.register(ReflectionUtil.createInstance(componentClass), priority);
        } else {
            this.clientBuilder.register(componentClass, priority);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        if (this.isSupportedCustomProvider(componentClass)) {
            this.register(ReflectionUtil.createInstance(componentClass), contracts);
        } else {
            this.clientBuilder.register(componentClass, (Class[])contracts);
        }
        return this;
    }

    public RestClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        if (this.isSupportedCustomProvider(componentClass)) {
            this.register(ReflectionUtil.createInstance(componentClass), contracts);
        } else {
            this.clientBuilder.register(componentClass, contracts);
        }
        return this;
    }

    public RestClientBuilder register(Object component) {
        if (component instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)component;
            this.registerCustomProvider(component, -1);
            this.clientBuilder.register((Object)mapper, mapper.getPriority());
        } else {
            this.clientBuilder.register(component);
            this.registerCustomProvider(component, -1);
        }
        return this;
    }

    public RestClientBuilder register(Object component, int priority) {
        this.clientBuilder.register(component, priority);
        this.registerCustomProvider(component, priority);
        return this;
    }

    public RestClientBuilder register(Object component, Class<?> ... contracts) {
        for (Class<?> contract : contracts) {
            if (!this.isSupportedCustomProvider(contract)) continue;
            this.register(component);
        }
        this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        if (this.isSupportedCustomProvider(component.getClass())) {
            if (component instanceof ResponseExceptionMapper) {
                this.registerCustomProvider(component, contracts.get(ResponseExceptionMapper.class));
            } else if (component instanceof ParamConverterProvider) {
                this.registerCustomProvider(component, contracts.get(ParamConverterProvider.class));
            }
        }
        this.clientBuilder.register(component, contracts);
        return this;
    }

    private boolean isSupportedCustomProvider(Class<?> providerClass) {
        return ResponseExceptionMapper.class.isAssignableFrom(providerClass) || ParamConverterProvider.class.isAssignableFrom(providerClass) || AsyncInvocationInterceptorFactory.class.isAssignableFrom(providerClass);
    }

    private void registerCustomProvider(Object instance, int priority) {
        if (!this.isSupportedCustomProvider(instance.getClass())) {
            return;
        }
        if (instance instanceof ResponseExceptionMapper) {
            this.responseExceptionMappers.add((ResponseExceptionMapper)instance);
            HashMap contracts = new HashMap();
            contracts.put(ResponseExceptionMapper.class, priority);
            this.configWrapper.addCustomProvider(instance.getClass(), contracts);
        }
        if (instance instanceof ParamConverterProvider) {
            this.paramConverterProviders.add((ParamConverterProvider)instance);
        }
        if (instance instanceof AsyncInvocationInterceptorFactory) {
            this.asyncInterceptorFactories.add((AsyncInvocationInterceptorFactory)instance);
        }
    }

    private static class InjectionManagerExposer
    implements Feature {
        InjectionManager injectionManager;

        private InjectionManagerExposer() {
        }

        public boolean configure(FeatureContext context) {
            if (context instanceof InjectionManagerSupplier) {
                this.injectionManager = ((InjectionManagerSupplier)context).getInjectionManager();
                return true;
            }
            throw new IllegalArgumentException("The client needs Jersey runtime to work properly");
        }
    }
}

