/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.glassfish.jersey.internal.util.ReflectionHelper;

class RestClientProducer
implements Bean<Object>,
PassivationCapable {
    private static final String CONFIG_URL = "/mp-rest/url";
    private static final String CONFIG_URI = "/mp-rest/uri";
    private static final String CONFIG_SCOPE = "/mp-rest/scope";
    private static final String CONFIG_CONNECTION_TIMEOUT = "/mp-rest/connectTimeout";
    private static final String CONFIG_READ_TIMEOUT = "/mp-rest/readTimeout";
    private final BeanManager beanManager;
    private final Class<?> interfaceType;
    private final Class<? extends Annotation> scope;
    private final Config config;
    private final String baseUrl;

    RestClientProducer(Class<?> interfaceType, BeanManager beanManager) {
        this.interfaceType = interfaceType;
        this.beanManager = beanManager;
        this.config = ConfigProvider.getConfig();
        this.baseUrl = this.getBaseUrl(interfaceType);
        this.scope = this.resolveProperClientScope();
    }

    private String getBaseUrl(Class<?> interfaceType) {
        Optional uri = this.config.getOptionalValue(interfaceType.getName() + CONFIG_URI, String.class);
        return uri.orElse(this.config.getOptionalValue(interfaceType.getName() + CONFIG_URL, String.class).orElseGet(() -> {
            RegisterRestClient registerRestClient = interfaceType.getAnnotation(RegisterRestClient.class);
            if (registerRestClient != null) {
                return registerRestClient.baseUri();
            }
            throw new DeploymentException("This interface has to be annotated with @RegisterRestClient annotation.");
        }));
    }

    public Class<?> getBeanClass() {
        return this.interfaceType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        try {
            RestClientBuilder restClientBuilder = RestClientBuilder.newBuilder().baseUrl(new URL(this.baseUrl));
            this.config.getOptionalValue(this.interfaceType.getName() + CONFIG_CONNECTION_TIMEOUT, Long.class).ifPresent(aLong -> restClientBuilder.connectTimeout(aLong.longValue(), TimeUnit.MILLISECONDS));
            this.config.getOptionalValue(this.interfaceType.getName() + CONFIG_READ_TIMEOUT, Long.class).ifPresent(aLong -> restClientBuilder.readTimeout(aLong.longValue(), TimeUnit.MILLISECONDS));
            return restClientBuilder.build(this.interfaceType);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("URL is not in valid format for Rest interface " + this.interfaceType.getName() + ": " + this.baseUrl);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.interfaceType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add((Annotation)new AnnotationLiteral<Default>(){});
        annotations.add((Annotation)new AnnotationLiteral<Any>(){});
        annotations.add((Annotation)RestClient.LITERAL);
        return annotations;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.interfaceType.getName() + "RestClient";
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String toString() {
        return "RestClientProducer [ interfaceType: " + this.interfaceType.getSimpleName() + " ] with Qualifiers [" + this.getQualifiers() + "]";
    }

    public String getId() {
        return this.interfaceType.getName();
    }

    private Class<? extends Annotation> resolveProperClientScope() {
        String configScope = this.config.getOptionalValue(this.interfaceType.getName() + CONFIG_SCOPE, String.class).orElse(null);
        if (configScope != null) {
            Class scope = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)configScope));
            if (scope == null) {
                throw new IllegalStateException("Invalid scope from config: " + configScope);
            }
            return scope;
        }
        List possibleScopes = Arrays.stream(this.interfaceType.getDeclaredAnnotations()).filter(annotation -> this.beanManager.isScope(annotation.annotationType())).collect(Collectors.toList());
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        throw new IllegalArgumentException("Client should have only one scope defined: " + this.interfaceType + " has " + possibleScopes);
    }
}

