/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.microprofile.restclient.InboundHeadersProvider;
import org.glassfish.jersey.microprofile.restclient.InterceptorInvocationContext;
import org.glassfish.jersey.microprofile.restclient.InterfaceModel;
import org.glassfish.jersey.microprofile.restclient.MethodModel;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;

class RestClientModel {
    private final InterfaceModel interfaceModel;
    private final Map<Method, MethodModel> methodModels;

    static RestClientModel from(Class<?> restClientClass, Set<ResponseExceptionMapper> responseExceptionMappers, Set<ParamConverterProvider> paramConverterProviders, Set<InboundHeadersProvider> inboundHeadersProviders, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories, InjectionManager injectionManager, BeanManager beanManager) {
        InterfaceModel interfaceModel = InterfaceModel.from(restClientClass, responseExceptionMappers, paramConverterProviders, inboundHeadersProviders, asyncInterceptorFactories, injectionManager, beanManager);
        return new Builder().interfaceModel(interfaceModel).methodModels(RestClientModel.parseMethodModels(interfaceModel)).build();
    }

    private RestClientModel(Builder builder) {
        this.interfaceModel = builder.classModel;
        this.methodModels = builder.methodModels;
    }

    <T> Object invokeMethod(WebTarget baseWebTarget, Method method, Object[] args) {
        WebTarget classLevelTarget = baseWebTarget.path(this.interfaceModel.getPath());
        MethodModel methodModel = this.methodModels.get(method);
        if (methodModel != null) {
            return new InterceptorInvocationContext(classLevelTarget, methodModel, method, args).proceed();
        }
        try {
            if (method.isDefault()) {
                Object instance = ReflectionUtil.createProxyInstance(this.interfaceModel.getRestClientClass());
                return method.invoke(instance, args);
            }
            throw new UnsupportedOperationException("This method is not supported!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Method, MethodModel> parseMethodModels(InterfaceModel classModel) {
        HashMap<Method, MethodModel> methodMap = new HashMap<Method, MethodModel>();
        for (Method method : classModel.getRestClientClass().getMethods()) {
            if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
            methodMap.put(method, MethodModel.from(classModel, method));
        }
        return methodMap;
    }

    public String toString() {
        return this.interfaceModel.getRestClientClass().getName();
    }

    private static class Builder {
        private InterfaceModel classModel;
        private Map<Method, MethodModel> methodModels;

        private Builder() {
        }

        Builder interfaceModel(InterfaceModel classModel) {
            this.classModel = classModel;
            return this;
        }

        Builder methodModels(Map<Method, MethodModel> methodModels) {
            this.methodModels = methodModels;
            return this;
        }

        public RestClientModel build() {
            return new RestClientModel(this);
        }
    }
}

