/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.glassfish.jersey.client.inject.ParameterUpdater;
import org.glassfish.jersey.client.inject.ParameterUpdaterProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.microprofile.restclient.ClientHeaderParamModel;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;
import org.glassfish.jersey.microprofile.restclient.RestClientContext;
import org.glassfish.jersey.model.Parameter;

class InterfaceModel {
    private static final Logger LOGGER = Logger.getLogger(InterfaceModel.class.getName());
    private final Class<?> restClientClass;
    private final String[] produces;
    private final String[] consumes;
    private final String path;
    private final ClientHeadersFactory clientHeadersFactory;
    private final CreationalContext<?> creationalContext;
    private final RestClientContext context;
    private final List<ClientHeaderParamModel> clientHeaders;
    private final Set<Annotation> interceptorAnnotations;

    static InterfaceModel from(RestClientContext context) {
        return new Builder(context).build();
    }

    private InterfaceModel(Builder builder) {
        this.restClientClass = builder.restClientClass;
        this.context = builder.context;
        this.path = builder.pathValue;
        this.produces = builder.produces;
        this.consumes = builder.consumes;
        this.clientHeaders = builder.clientHeaders;
        this.clientHeadersFactory = builder.clientHeadersFactory;
        this.interceptorAnnotations = builder.interceptorAnnotations;
        this.creationalContext = builder.creationalContext;
    }

    Class<?> getRestClientClass() {
        return this.restClientClass;
    }

    String[] getProduces() {
        return this.produces;
    }

    String[] getConsumes() {
        return this.consumes;
    }

    String getPath() {
        return this.path;
    }

    Optional<ClientHeadersFactory> getClientHeadersFactory() {
        return Optional.ofNullable(this.clientHeadersFactory);
    }

    List<ClientHeaderParamModel> getClientHeaders() {
        return this.clientHeaders;
    }

    RestClientContext context() {
        return this.context;
    }

    Set<Annotation> getInterceptorAnnotations() {
        return this.interceptorAnnotations;
    }

    CreationalContext<?> getCreationalContext() {
        return this.creationalContext;
    }

    Object resolveParamValue(Object arg, Parameter parameter) {
        Iterable parameterUpdaterProviders = Providers.getAllProviders((InjectionManager)this.context.injectionManager(), ParameterUpdaterProvider.class);
        for (ParameterUpdaterProvider parameterUpdaterProvider : parameterUpdaterProviders) {
            if (parameterUpdaterProvider == null) continue;
            ParameterUpdater updater = parameterUpdaterProvider.get(parameter);
            return updater.update(arg);
        }
        return arg;
    }

    private static class Builder {
        private final Class<?> restClientClass;
        private final RestClientContext context;
        private String pathValue;
        private String[] produces;
        private String[] consumes;
        private ClientHeadersFactory clientHeadersFactory;
        private CreationalContext<?> creationalContext;
        private List<ClientHeaderParamModel> clientHeaders;
        private Set<Annotation> interceptorAnnotations;

        private Builder(RestClientContext context) {
            this.restClientClass = context.restClientClass();
            this.context = context;
            this.filterAllInterceptorAnnotations();
        }

        private void filterAllInterceptorAnnotations() {
            this.creationalContext = null;
            this.interceptorAnnotations = new HashSet<Annotation>();
            BeanManager beanManager = this.context.beanManager();
            if (beanManager != null) {
                this.creationalContext = beanManager.createCreationalContext(null);
                for (Annotation annotation : this.restClientClass.getAnnotations()) {
                    if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
                    this.interceptorAnnotations.add(annotation);
                }
            }
        }

        Builder pathValue(Path path) {
            this.pathValue = path != null ? path.value() : "";
            this.pathValue = this.pathValue.equals("/") ? "" : this.pathValue;
            return this;
        }

        Builder produces(Produces produces) {
            String[] stringArray;
            if (produces != null) {
                stringArray = produces.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "application/json";
            }
            this.produces = stringArray;
            return this;
        }

        Builder consumes(Consumes consumes) {
            String[] stringArray;
            if (consumes != null) {
                stringArray = consumes.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "application/json";
            }
            this.consumes = stringArray;
            return this;
        }

        Builder clientHeaders(ClientHeaderParam[] clientHeaderParams) {
            this.clientHeaders = Arrays.stream(clientHeaderParams).map(clientHeaderParam -> new ClientHeaderParamModel(this.restClientClass, (ClientHeaderParam)clientHeaderParam)).collect(Collectors.toList());
            return this;
        }

        Builder clientHeadersFactory(RegisterClientHeaders registerClientHeaders) {
            if (registerClientHeaders != null) {
                Class value = registerClientHeaders.value();
                try {
                    this.clientHeadersFactory = (ClientHeadersFactory)CDI.current().select(value, new Annotation[0]).get();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, ex, () -> "This class is not a CDI bean. " + value);
                    this.clientHeadersFactory = (ClientHeadersFactory)ReflectionUtil.createInstance(value);
                }
            }
            return this;
        }

        InterfaceModel build() {
            this.pathValue(this.restClientClass.getAnnotation(Path.class));
            this.produces(this.restClientClass.getAnnotation(Produces.class));
            this.consumes(this.restClientClass.getAnnotation(Consumes.class));
            this.clientHeaders((ClientHeaderParam[])this.restClientClass.getAnnotationsByType(ClientHeaderParam.class));
            this.clientHeadersFactory(this.restClientClass.getAnnotation(RegisterClientHeaders.class));
            this.validateHeaderDuplicityNames();
            return new InterfaceModel(this);
        }

        private void validateHeaderDuplicityNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (ClientHeaderParamModel clientHeaderParamModel : this.clientHeaders) {
                String headerName = clientHeaderParamModel.getHeaderName();
                if (names.contains(headerName)) {
                    throw new RestClientDefinitionException("Header name cannot be registered more then once on the same target.See " + this.restClientClass.getName());
                }
                names.add(headerName);
            }
        }
    }
}

